import { fakeAsync,
        async,
        tick,
        ComponentFixture,
        TestBed } from '@angular/core/testing'
import * as Axe from 'axe-core'
import { HttpModule} from "@angular/http"
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../karma/karma-helper'
import { RouterTestingModule } from '@angular/router/testing';
import { FaqComponent } from './faq.component';
import { BreadcrumbService } from '../../core/breadcrumb/breadcrumb.service'
import { BreadcrumbComponent } from '../breadcrumb/breadcrumb.component'

describe('FaqComponent', () => {
  let component: FaqComponent;
  let fixture: ComponentFixture<FaqComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [ RouterTestingModule.withRoutes([]) ],
      declarations: [
        FaqComponent,
        BreadcrumbComponent
      ],
      providers: [ BreadcrumbService ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(FaqComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should have no accessibility issues', ((done) => {

    Axe.run(document, KarmaHelper.axeOptions()).then((result) => {
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error) => {
        console.error("AXE-CORE ERROR:" + error)
    })
  }))

});
