import { Component, Input, ContentChildren } from '@angular/core';
import { ExtLinkService } from '../../core/ext-link/ext-link.service'
import { ExtLink } from '../../core/ext-link/ext-link'

@Component({
  selector: 'app-ext-link',
  templateUrl: './ext-link.component.html',
  styleUrls: ['./ext-link.component.css']
})
export class ExtLinkComponent {
  @Input() href: string // redirect URL
  @Input() sitename: string // site name shown on warning popup
  @Input() title: string // link text
  @Input() blank: boolean // optional: open new page in browser tab
  @Input() blanktext: string // optional: text shown on new page

  constructor(private extLinkService: ExtLinkService) { }

  click() {
    let extLink = new ExtLink()
    extLink.href = this.href
    extLink.title = this.title
    extLink.sitename = this.sitename
    extLink.blanktext = this.blanktext
    extLink.blank = this.blank
    this.extLinkService.open(extLink)
  }

}
