import { Component, OnInit } from '@angular/core'
import { BreadcrumbService } from '../../core/breadcrumb/breadcrumb.service'
import { MainContentService } from '../../core/maincontent/maincontent.service'
import { MainContent } from '../../core/maincontent/maincontent'

@Component({
  selector: 'app-contact',
  templateUrl: './contact.component.html',
  styleUrls: ['./contact.component.css']
})
export class ContactComponent implements OnInit {
  maincontent: MainContent

  constructor(private breadcrumbService: BreadcrumbService,
              private maincontentService: MainContentService) { }

  ngOnInit() {
    this.breadcrumbService.reset()
    this.maincontentService.getContent().subscribe(this.contentUpdate.bind(this))
  }

  contentUpdate(data: any) {
    this.maincontent = data
  }

}
