import { fakeAsync,
        async,
        tick,
        ComponentFixture,
        TestBed } from '@angular/core/testing'
import * as Axe from 'axe-core'
import { HttpModule} from "@angular/http"
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../karma/karma-helper'
import { RouterTestingModule } from '@angular/router/testing';
import { ContactComponent } from './contact.component';
import { BreadcrumbService } from '../../core/breadcrumb/breadcrumb.service'
import { BreadcrumbComponent } from '../breadcrumb/breadcrumb.component'
import { MainContentService } from '../../core/maincontent/maincontent.service'
import { MainContent } from '../../core/maincontent/maincontent'
import { ConfigService } from '../../core/config/config.service'
import { EnvironmentService } from '../../core/env/environment.service'

describe('ContactComponent', () => {
  let component: ContactComponent;
  let fixture: ComponentFixture<ContactComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [HttpModule,
                RouterTestingModule.withRoutes([])
    ],
      declarations: [
        ContactComponent,
        BreadcrumbComponent
      ],
      providers: [BreadcrumbService,
                  ConfigService,
                  EnvironmentService,
                  MainContentService]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(ContactComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('select page should have no accessibility issues', (done) => {
    component.maincontent = new MainContent()
    component.maincontent.phone = "777-7777"
    component.maincontent.emailText = "myEmail"
    component.maincontent.emailValue = "myEmail@myemail.us"
    fixture.detectChanges()

    // console.error(" @@@@@@@@@@@@@ html="+document.body.innerHTML)
    Axe.run(document, KarmaHelper.axeOptions()).then((result) => {
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error) => {
      console.error("AXE-CORE ERROR:" + error)

    })
  })


});
