import { Component, OnInit, OnDestroy} from '@angular/core'
import { Router, ActivatedRoute, RouterLink,
          NavigationEnd, Params, PRIMARY_OUTLET } from '@angular/router'
import { BreadcrumbService } from '../../core/breadcrumb/breadcrumb.service'
import { Crumb } from '../../core/breadcrumb/crumb'
import { Subscription } from "rxjs/Subscription"
import { Breadcrumb } from './breadcrumb'
import 'rxjs/add/operator/filter'

const ROUTE_DATA_BREADCRUMB = 'breadcrumb'

@Component({
  selector: 'app-tas-breadcrumb',
  templateUrl: './breadcrumb.component.html',
  styleUrls: ['./breadcrumb.component.css']
})
export class BreadcrumbComponent implements OnInit, OnDestroy {
  _sub: Subscription

  children = new Array<RouterLink>();

  constructor(
    private activatedRoute: ActivatedRoute,
    private router: Router,
    private breadcrumbService: BreadcrumbService
  ) { }

  ngOnInit() {
    this._sub = this.router.events.filter(event => event instanceof NavigationEnd)
    .subscribe(event => {
      let root: ActivatedRoute = this.activatedRoute.root
      this.getBreadcrumbs(root)
    })
  }

  ngOnDestroy() {
    this._sub.unsubscribe()
  }

  private getBreadcrumbs(
      route: ActivatedRoute,
      url: string= '',
      breadcrumbs: Breadcrumb[] = []
  ): Breadcrumb[] {
    let children: ActivatedRoute[] = route.children

    if ( children.length === 0 ) {
      return breadcrumbs
    }

    for ( let child of children ) {

      if ( child.outlet !== PRIMARY_OUTLET ) {
        continue
      }

      if ( !child.snapshot.data.hasOwnProperty(ROUTE_DATA_BREADCRUMB)) {
        return this.getBreadcrumbs(child, url, breadcrumbs)
      }

      let routeURL = child.snapshot.url.map(segment => segment.path).join('/')
      url += `/${routeURL}`

      let crumb = new Crumb()
      crumb.url = '/' + child.snapshot.parent.url + url
      crumb.path = child.snapshot.routeConfig.path
      crumb.label = child.snapshot.data[ROUTE_DATA_BREADCRUMB]
      this.breadcrumbService.push(crumb)

    }

  }

}
