import {async, ComponentFixture, fakeAsync, getTestBed, TestBed, tick} from '@angular/core/testing'
import * as Axe from 'axe-core'
import {KarmaHelper} from '../../../../karma/karma-helper'
import {RouterTestingModule} from '@angular/router/testing'
import {BreadcrumbService} from '../../core/breadcrumb/breadcrumb.service'
import {BreadcrumbComponent} from './breadcrumb.component'
import {Crumb} from '../../core/breadcrumb/crumb'


describe('BreadcrumbComponent', () => {
  let component: BreadcrumbComponent
  let fixture: ComponentFixture<BreadcrumbComponent>

  let breadServiceStub = {
    crumbs: [
      {
        url: "",
        label: "Web Home",
        path: "Main Home Page"
      },
      {
        url: "/server/home",
        label: "Module home",
        path: "home"
      },
      {
        url: "/server/sub",
        label: "test sub page",
        path: "subpage"
      }
    ]
  }

  beforeEach(() => {

    TestBed.configureTestingModule({
      imports: [
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
        BreadcrumbComponent
      ],
      providers: [
        {provide: BreadcrumbService, useValue: breadServiceStub }
      ]
    }).compileComponents()

    fixture = TestBed.createComponent(BreadcrumbComponent)
    component = fixture.componentInstance

  })

  afterEach(function () {
    TestBed.resetTestingModule()
  });

  it('should have no accessibility issues', ((done) => {
    fixture.detectChanges()
    // console.error(' @@@@@@@@@@@@@ html=' + document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions()).then((result) => {
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error) => {
      console.error('AXE-CORE ERROR:' + error)
    })
  }))

})
