import { Injectable, ReflectiveInjector } from '@angular/core'
import {Http, XHRBackend, RequestOptions, Request, RequestOptionsArgs, Response, Headers} from '@angular/http'
import {Observable} from 'rxjs/Observable'

@Injectable()
export class TasHttp extends Http {
  starttime = 0

  constructor (backend: XHRBackend, options: RequestOptions) {
    super(backend, options)
  }

  private requestOptions(options?: RequestOptionsArgs): RequestOptionsArgs {
    if (options == null) {
      options = new RequestOptions()
    }
    if (options.headers == null) {
      options.headers = new Headers({})
    }
    return options
  }

  get(url: string, options?: RequestOptionsArgs): Observable<any> {

    this.starttime = Date.now()

    return super.get(url, this.requestOptions(options))
      .catch(this.onCatch)
      .do((res: Response) => {

        if (this.starttime !== 0) {
          let roundtrip = Date.now() - this.starttime
          console.log("http roundtrip: " + roundtrip + 'ms' + ' ' + res.url)
          this.starttime = 0
        }

      }, (error: any) => {
        this.onError(error)
      })

  }

  onCatch(error: any, caught: Observable<any>): Observable<any> {
    console.error(error)
    return Observable.throw(error)
  }

  onError(error: any): void {
    console.error("err:" + error)
  }

}
