import { Injectable } from '@angular/core'
import { Response, Headers, Http } from '@angular/http'

import { Observable } from 'rxjs/Observable'

import 'rxjs/add/operator/map'
import 'rxjs/add/operator/catch'
import 'rxjs/add/operator/toPromise'
import 'rxjs/add/observable/throw'

// import { Config } from '../config/config'
import { ConfigService } from '../config/config.service'
import { SearchApiServiceStub } from './search-api.service.stub'
import { EnvironmentService } from '../env/environment.service'

import { PagedEntry } from './paged-entry'

@Injectable()
export class SearchApiService {
  private url: string
  private inner: SearchApiServiceStub
  private enable_api: boolean

  private handleError(error: any): Promise<any> {
    console.error('An error occurred', error)
    error = error.message || JSON.parse(error._body) || error
    if (error.error) {
      error = error.error
    }
    return Promise.reject(error)
  }

  //  private headers = new Headers({ 'Content-Type': 'application/json', 'X-Key': '12345', 'X-UserId': 'uiuser01' })

  constructor(
    private configService: ConfigService,
    private http: Http,
    private env: EnvironmentService
  ) {
    this.env.getEnv()
      .subscribe(environment => {
        this.enable_api = environment['enable_api']
        // TODO use getServices() LocalConfig.ApiServer
        this.url = '/api/core/api/v2/search'
      })

    this.inner = new SearchApiServiceStub()
  }

  tokenizationTerms(table: string, property: string): Observable<any> {
    if (this.enable_api === false) {
      return this.inner.tokenizationTerms(table, property)
    } else {
      throw new Error('Not implemented. There is no backend search.')
    }
  }

  stats(table: string, property: string, aggregate: string): Observable<any> {
    if (this.enable_api === false) {
      return this.inner.stats(table, property, aggregate)
    } else {
      throw new Error('Not implemented. There is no backend search.')
    }
  }

  _dump(table: string): Promise<any> {
    if (this.enable_api === false) {
      return this.inner._dump(table)
    } else {
      throw new Error('Not implemented. There is no backend search.')
    }
  }

  sample(options: { [name: string]: any; }): Observable<Array<any>> {
    if (this.enable_api === false) {
      return this.inner.sample(options)
    } else {
      throw new Error('Not implemented. There is no backend search.')
    }
  }

  search(options: { [name: string]: any; }): Observable<PagedEntry> {
    if (this.enable_api === false) {
      return this.inner.search(options)
    } else {
      throw new Error('Not implemented. There is no backend search.')
    }
  }

  filter(options: { [name: string]: any; }): Observable<PagedEntry> {
    if (this.enable_api === false) {
      return this.inner.filter(options)
    } else {
      throw new Error('Not implemented. There is no backend search.')
    }
  }
}
