import { Injectable } from '@angular/core'
import { Headers, Http, Response } from '@angular/http'
import { Observable } from 'rxjs/Rx'
import { Menu } from './menu'
import { ConfigService } from '../../core/config/config.service'

@Injectable()
export class MenusService {
  private _menus: Observable<any>
  private menuGUID

  constructor(private configService: ConfigService) { }

  public getMenus(): Observable<Menu[]> {
    return Observable.create(observer => {
      this.configService.load(["menus"])
        .subscribe(config => {
          observer.next(this.mapMenu(config['menus']))
          observer.complete()
        })
    })
  }

  public setMenus(menus: Menu[]) {
    return this._setMenus(menus)
  }

  private _setMenus(menus: Menu[]): Observable<Response> {
    return this.configService.update("menus", menus)
  }

  private mapMenu(menus: any): Menu[] {
    // TODO we are using the first menu item, will need to map user.group.menu.id
    let item0 = menus;
    this.menuGUID = "menus";
    return item0.map(this.toMenu);
  }

  private toMenu(r: any): Menu {
    const menu = <Menu>({
      title: r.title,
      uri: r.uri,
      subMenu: r.subMenu
    });
    return menu;
  }

  handleError(err: any) {
    console.log('sever error:', err);  // debug
    if (err instanceof Response) {
      return Observable.throw(this.getErrorMessage(err));
    }
    return Observable.throw(err || 'backend server error');
  }

  getErrorMessage(err) {
    let error = err.json();
    if (typeof error === 'object' && error.resourceType === 'OperationOutcome' && error.issue && error.issue[0]) {
      return {
        errorCode: 504, // VA-FHIR-Server error
        message: error.issue[0].diagnostics || 'VA-FHIR-Server Error - unknown'
      }
    } else {
      return err.error || 'unknown server error'
    }
  }
}
