import { async, inject, TestBed } from '@angular/core/testing';
import { MockBackend, MockConnection } from '@angular/http/testing';
import { BaseRequestOptions, Connection, Http, Response, ResponseOptions } from '@angular/http';
import { ConfigService } from '../../core/config/config.service'
import { EnvironmentService } from '../../core/env/environment.service'

import { MenusService } from './menus.service';

describe('MenusService', function () {
  let menuService: MenusService;
  let backend: MockBackend;
  let lastConnection: Connection;

  beforeEach(function () {

    TestBed.configureTestingModule({
      providers: [
        MenusService,
        MockBackend,
        ConfigService,
        EnvironmentService,
        BaseRequestOptions,
        {
          provide: Http,
          useFactory: function (mockBackend, defaultOptions) {
            return new Http(mockBackend, defaultOptions);
          },
          deps: [MockBackend, BaseRequestOptions]
        }
      ]
    });

  });

  beforeEach(inject([MenusService, MockBackend], function (MenusService, mockBackend) {
    menuService = MenusService;
    backend = mockBackend;
    backend.connections.subscribe((connection: any) => lastConnection = connection);
  }));

  it('should construct', async(inject(
    [MenusService, MockBackend], (service, mockBackend) => {

      expect(service).toBeDefined();
    })));

  // it('should query current service url', () => {
  //   menuService.getMenus(false);
  //   expect(lastConnection).toBeDefined('no http service connection at all?');
  // });

  it('should get data', function (done) {

    // backend.connections.subscribe(function (connection: MockConnection) {

    //   let options = new ResponseOptions({
    //     body: [{ title: 'eInsurance', uri: 'einsurance/home' },
    //     { title: 'ePharmacy', uri: 'epharmacy/home' },
    //     { title: 'eBilling', uri: 'ebilling/home' },
    //     { title: 'ePayments', uri: 'epayments/home' },
    //     { title: 'Non-MCCF', uri: 'non-mccf/home' },
    //     { title: 'NPI', uri: 'npi/home' }]
    //   });
    //   connection.mockRespond(new Response(options));
    // });

    menuService.getMenus().subscribe(function (response) {
      expect(response).toEqual(jasmine.any(Array));
      expect(response[0].title).toEqual('eInsurance');
      expect(response[0].uri).toEqual('einsurance/home');
      // expect(response[0].subMenu[0].title).toEqual('google');
      // expect(response[0].subMenu.length).toEqual(4);
    },
      function (e) {
        fail(e);
      }
    );

    done();
  });

  afterEach(function () {
    TestBed.resetTestingModule();
  });


});
