import { Injectable } from '@angular/core'
import { Headers, Http, Response } from '@angular/http'
import { Observable } from 'rxjs/Rx'
import { MainContent } from './maincontent'
import { Product } from './product'
import { ProductLink } from './product-link'
import { ConfigService } from '../config/config.service'

@Injectable()
export class MainContentService {
  private productName: string
  private _maincontent: any
  private _product: any
  private mainContentGUID
  private coreAPI
  private enable_api

  constructor(private http: Http, private configService: ConfigService) {
    console.log('MainContentService cTor')
  }

  public getContent(): Observable<MainContent> {
    return Observable.create(observer => {
      if (this._maincontent) {
        observer.next(this._maincontent)
        observer.complete()
      } else {
        this.configService.load(["products", "contact"])
          .subscribe(config => {
            this._maincontent = this.mapMainContent(config)
            observer.next(this._maincontent)
            observer.complete()
          })
      }
    })
  }

  public saveContent(mainContent: MainContent) {
    return this._saveContent(mainContent)
  }

  private _saveContent(mainContent: MainContent): Observable<boolean> {
    const contact = {
      phone: mainContent.phone,
      emailText: mainContent.emailText,
      emailValue: mainContent.emailValue
    }
    const products = mainContent.product.map(p => {
      let clone = Object.assign(p)
      delete clone.links
      return clone
    })
    return Observable.create(observer => {
      // this.configService.update('core:help', mainContent.helpContent)
      //   .subscribe(() =>
      //     this.configService.update('contact', contact)
      //       .subscribe(() => {
      //         this.configService.update('products', products)
      //           .subscribe(() => {
      observer.next()
      observer.complete()
      //           })
      //       })
      //   )
    })
  }

  public getProduct(productName: string): Observable<Product> {
    return Observable.create(o => {
      if (!this._maincontent) {
        this.configService.load(["products", "contact"])
          .subscribe(config => {
            this._maincontent = this.mapMainContent(config)
            let prod: Product = this._maincontent['product'].filter(p => p.name === productName)
            this.productName = productName
            o.next(prod[0])
            o.complete()
          })
      } else {
        let prod: Product = this._maincontent['product'].filter(p => p.name === productName)
        this.productName = productName
        o.next(prod[0])
        o.complete()
      }
    })
  }

  public getHelpContent(product: string): Observable<string> {
    return Observable.create(o => {
      this.configService.load([`${product}:help`])
          .subscribe(res => {
            o.next(res)
            o.complete()
          })
      })
  }

  public saveHelpContent(product: string, content: string): Observable<string> {
    return Observable.create(o => {
      this.configService.update(`${product.toLowerCase()}:help`, content)
        .subscribe((res) => {
          o.next(res)
          o.complete()
        })
      })
  }

  private mapMainContent(res: any): MainContent {
    let item0 = res
    this.mainContentGUID = "maincontent"
    let response = item0
    let mainContent = new MainContent()
    let products: Array<Product> = response["products"]

    for (let i = 0; i < products.length; i++) {
      let prod: Product = new Product()

      prod.name = products[i].name
      prod.erevenueUrl = products[i].erevenueUrl

      mainContent.product.push(prod)
    }

    const contact = response["contact"]

    mainContent.phone = contact["phone"]
    mainContent.emailText = contact["emailText"]
    mainContent.emailValue = contact["emailValue"]

    return mainContent
  }

  handleError(err: any) {
    console.log('sever error:', err);  // debug
    if (err instanceof Response) {
      return Observable.throw(this.getErrorMessage(err))
    }
    return Observable.throw(err || 'backend server error')
  }

  getErrorMessage(err) {
    let error = err.json()
    if (typeof error === 'object' && error.resourceType === 'OperationOutcome' && error.issue && error.issue[0]) {
      return {
        errorCode: 504, // VA-FHIR-Server error
        message: error.issue[0].diagnostics || 'VA-FHIR-Server Error - unknown'
      }
    } else {
      return err.error || 'unknown server error'
    }
  }

}
