import { inject, TestBed } from '@angular/core/testing'
import { HttpModule, Http, BaseRequestOptions, XHRBackend } from '@angular/http';
import { MockBackend } from '@angular/http/testing';

import { ConfigService } from '../config/config.service'
// import { Config } from '../config/config'
import { LoggingApiService } from './logging-api.service'
import { EnvironmentService } from '../../core/env/environment.service'

describe('LoggingApiService', function () {
    const dataToImport = [{ "ts": 1498832900611, "value": { "id": "b0cb117f6f92514f55", "outcomeDesc": "RouteConfigLoadEnd(path: common)", "type": "6", "recorded": 1498832900611 }, "$text": "{\"id\":\"b0cb117f6f92514f55\",\"outcomeDesc\":\"RouteConfigLoadEnd(path: common)\",\"type\":\"6\",\"recorded\":1498832900611}", "partition_key": "log", "row_key": "b0cb117f6f92514f55" }, { "ts": 1498832900620, "value": { "id": "2c9d1621110d2fdcfc", "outcomeDesc": "RoutesRecognized(id: 1, url: '/common/logger', urlAfterRedirects: '/common/logger', state: Route(url:'', path:'') { Route(url:'common', path:'common') { Route(url:'logger', path:'logger') }  } )", "type": "6", "recorded": 1498832900619 }, "$text": "{\"id\":\"2c9d1621110d2fdcfc\",\"outcomeDesc\":\"RoutesRecognized(id: 1, url: '/common/logger', urlAfterRedirects: '/common/logger', state: Route(url:'', path:'') { Route(url:'common', path:'common') { Route(url:'logger', path:'logger') }  } )\",\"type\":\"6\",\"recorded\":1498832900619}", "partition_key": "log", "row_key": "2c9d1621110d2fdcfc" }, { "ts": 1498832900702, "value": { "id": "dc3bb7211186f1660d", "outcomeDesc": "NavigationEnd(id: 1, url: '/common/logger', urlAfterRedirects: '/common/logger')", "type": "6", "recorded": 1498832900700 }, "$text": "{\"id\":\"dc3bb7211186f1660d\",\"outcomeDesc\":\"NavigationEnd(id: 1, url: '/common/logger', urlAfterRedirects: '/common/logger')\",\"type\":\"6\",\"recorded\":1498832900700}", "partition_key": "log", "row_key": "dc3bb7211186f1660d" }, { "ts": 1498832900710, "value": { "id": "1976f0301374712780", "outcomeDesc": "1LoggerComponent:: ERROR database offline", "type": "3", "recorded": 1498832900707 }, "$text": "{\"id\":\"1976f0301374712780\",\"outcomeDesc\":\"1LoggerComponent:: ERROR database offline\",\"type\":\"3\",\"recorded\":1498832900707}", "partition_key": "log", "row_key": "1976f0301374712780" }, { "ts": 1498832900713, "value": { "id": "bffc356560a714310", "outcomeDesc": "2LoggerComponent:: WARN update called 2 times", "type": "4", "recorded": 1498832900709 }, "$text": "{\"id\":\"bffc356560a714310\",\"outcomeDesc\":\"2LoggerComponent:: WARN update called 2 times\",\"type\":\"4\",\"recorded\":1498832900709}", "partition_key": "log", "row_key": "bffc356560a714310" }, { "ts": 1498832900715, "value": { "id": "282ba6a2138855c78", "outcomeDesc": "3LoggerComponent::testLogger", "type": "6", "recorded": 1498832900710 }, "$text": "{\"id\":\"282ba6a2138855c78\",\"outcomeDesc\":\"3LoggerComponent::testLogger\",\"type\":\"6\",\"recorded\":1498832900710}", "partition_key": "log", "row_key": "282ba6a2138855c78" }, { "ts": 1498832900716, "value": { "id": "f563b0d9802b83ff", "outcomeDesc": "5LoggerComponent::testLogger", "type": "6", "recorded": 1498832900710 }, "$text": "{\"id\":\"f563b0d9802b83ff\",\"outcomeDesc\":\"5LoggerComponent::testLogger\",\"type\":\"6\",\"recorded\":1498832900710}", "partition_key": "log", "row_key": "f563b0d9802b83ff" }, { "ts": 1498832900718, "value": { "id": "723aff891699918f4", "outcomeDesc": "6LoggerComponent::testLogger", "type": "6", "recorded": 1498832900711 }, "$text": "{\"id\":\"723aff891699918f4\",\"outcomeDesc\":\"6LoggerComponent::testLogger\",\"type\":\"6\",\"recorded\":1498832900711}", "partition_key": "log", "row_key": "723aff891699918f4" }, { "ts": 1498832900720, "value": { "id": "d27976e157f217dbe", "outcomeDesc": "7LoggerComponent::testLogger 982193023  details on submitting form; patient number 2984239423. 21312l3 123; sys update database input return 321kl3 note: 12 3123kj 21hkl31", "type": "6", "recorded": 1498832900712 }, "$text": "{\"id\":\"d27976e157f217dbe\",\"outcomeDesc\":\"7LoggerComponent::testLogger 982193023  details on submitting form; patient number 2984239423. 21312l3 123; sys update database input return 321kl3 note: 12 3123kj 21hkl31\",\"type\":\"6\",\"recorded\":1498832900712}", "partition_key": "log", "row_key": "d27976e157f217dbe" }, { "ts": 1498832900722, "value": { "id": "1385f22df3f2cf2a", "outcomeDesc": "8LoggerComponent::testLogger", "type": "6", "recorded": 1498832900713 }, "$text": "{\"id\":\"1385f22df3f2cf2a\",\"outcomeDesc\":\"8LoggerComponent::testLogger\",\"type\":\"6\",\"recorded\":1498832900713}", "partition_key": "log", "row_key": "1385f22df3f2cf2a" }, { "ts": 1498832900724, "value": { "id": "a868335718e4df9b", "outcomeDesc": "9LoggerComponent:: ERROR2 database offline", "type": "3", "recorded": 1498832900714 }, "$text": "{\"id\":\"a868335718e4df9b\",\"outcomeDesc\":\"9LoggerComponent:: ERROR2 database offline\",\"type\":\"3\",\"recorded\":1498832900714}", "partition_key": "log", "row_key": "a868335718e4df9b" }, { "ts": 1498832900726, "value": { "id": "81fe134083d11d18", "outcomeDesc": "10LoggerComponent:: WARN2 update called", "type": "4", "recorded": 1498832900715 }, "$text": "{\"id\":\"81fe134083d11d18\",\"outcomeDesc\":\"10LoggerComponent:: WARN2 update called\",\"type\":\"4\",\"recorded\":1498832900715}", "partition_key": "log", "row_key": "81fe134083d11d18" }, { "ts": 1498832900728, "value": { "id": "13f4ccbd22faad750", "outcomeDesc": "11LoggerComponent::testLogger2", "type": "6", "recorded": 1498832900716 }, "$text": "{\"id\":\"13f4ccbd22faad750\",\"outcomeDesc\":\"11LoggerComponent::testLogger2\",\"type\":\"6\",\"recorded\":1498832900716}", "partition_key": "log", "row_key": "13f4ccbd22faad750" }, { "ts": 1498832900730, "value": { "id": "3c110c815a65a6", "outcomeDesc": "13LoggerComponent::testLogger2", "type": "6", "recorded": 1498832900717 }, "$text": "{\"id\":\"3c110c815a65a6\",\"outcomeDesc\":\"13LoggerComponent::testLogger2\",\"type\":\"6\",\"recorded\":1498832900717}", "partition_key": "log", "row_key": "3c110c815a65a6" }, { "ts": 1498832900732, "value": { "id": "c4bea6cecabfbf4", "outcomeDesc": "14LoggerComponent::testLogger2", "type": "6", "recorded": 1498832900718 }, "$text": "{\"id\":\"c4bea6cecabfbf4\",\"outcomeDesc\":\"14LoggerComponent::testLogger2\",\"type\":\"6\",\"recorded\":1498832900718}", "partition_key": "log", "row_key": "c4bea6cecabfbf4" }, { "ts": 1498832900733, "value": { "id": "162441659312dc879a", "outcomeDesc": "15LoggerComponent::testLogger2 982193023  details on submitting form; patient number 2984239423. 21312l3 123; sys update database input return 321kl3 note: 12 3123kj 21hkl31", "type": "6", "recorded": 1498832900718 }, "$text": "{\"id\":\"162441659312dc879a\",\"outcomeDesc\":\"15LoggerComponent::testLogger2 982193023  details on submitting form; patient number 2984239423. 21312l3 123; sys update database input return 321kl3 note: 12 3123kj 21hkl31\",\"type\":\"6\",\"recorded\":1498832900718}", "partition_key": "log", "row_key": "162441659312dc879a" }, { "ts": 1498832900735, "value": { "id": "bdf7319e3459aa10", "outcomeDesc": "16LoggerComponent::testLogger3", "type": "6", "recorded": 1498832900719 }, "$text": "{\"id\":\"bdf7319e3459aa10\",\"outcomeDesc\":\"16LoggerComponent::testLogger3\",\"type\":\"6\",\"recorded\":1498832900719}", "partition_key": "log", "row_key": "bdf7319e3459aa10" }, { "ts": 1498832900737, "value": { "id": "174121755f13b6917f27", "outcomeDesc": "17LoggerComponent:: ERROR3 database offline", "type": "3", "recorded": 1498832900720 }, "$text": "{\"id\":\"174121755f13b6917f27\",\"outcomeDesc\":\"17LoggerComponent:: ERROR3 database offline\",\"type\":\"3\",\"recorded\":1498832900720}", "partition_key": "log", "row_key": "174121755f13b6917f27" }, { "ts": 1498832900739, "value": { "id": "e32112b06a5c64371", "outcomeDesc": "18LoggerComponent:: WARN3 update called", "type": "4", "recorded": 1498832900721 }, "$text": "{\"id\":\"e32112b06a5c64371\",\"outcomeDesc\":\"18LoggerComponent:: WARN3 update called\",\"type\":\"4\",\"recorded\":1498832900721}", "partition_key": "log", "row_key": "e32112b06a5c64371" }, { "ts": 1498832900741, "value": { "id": "971041f0317dec4", "outcomeDesc": "19LoggerComponent::testLogger3", "type": "6", "recorded": 1498832900722 }, "$text": "{\"id\":\"971041f0317dec4\",\"outcomeDesc\":\"19LoggerComponent::testLogger3\",\"type\":\"6\",\"recorded\":1498832900722}", "partition_key": "log", "row_key": "971041f0317dec4" }, { "ts": 1498832900743, "value": { "id": "4b7c1540d289de706", "outcomeDesc": "21LoggerComponent::testLogger3", "type": "6", "recorded": 1498832900723 }, "$text": "{\"id\":\"4b7c1540d289de706\",\"outcomeDesc\":\"21LoggerComponent::testLogger3\",\"type\":\"6\",\"recorded\":1498832900723}", "partition_key": "log", "row_key": "4b7c1540d289de706" }, { "ts": 1498832900744, "value": { "id": "540015ac4b6fb15380", "outcomeDesc": "22LoggerComponent::testLogger3", "type": "6", "recorded": 1498832900723 }, "$text": "{\"id\":\"540015ac4b6fb15380\",\"outcomeDesc\":\"22LoggerComponent::testLogger3\",\"type\":\"6\",\"recorded\":1498832900723}", "partition_key": "log", "row_key": "540015ac4b6fb15380" }, { "ts": 1498832900746, "value": { "id": "4d4e121ab48dc11289", "outcomeDesc": "23LoggerComponent::testLogger3 982193023  details on submitting form; patient number 2984239423. 21312l3 123; sys update database input return 321kl3 note: 12 3123kj 21hkl31", "type": "6", "recorded": 1498832900724 }, "$text": "{\"id\":\"4d4e121ab48dc11289\",\"outcomeDesc\":\"23LoggerComponent::testLogger3 982193023  details on submitting form; patient number 2984239423. 21312l3 123; sys update database input return 321kl3 note: 12 3123kj 21hkl31\",\"type\":\"6\",\"recorded\":1498832900724}", "partition_key": "log", "row_key": "4d4e121ab48dc11289" }, { "ts": 1498832900748, "value": { "id": "e6b74ca893a011b8", "outcomeDesc": "24LoggerComponent::testLogger3", "type": "6", "recorded": 1498832900725 }, "$text": "{\"id\":\"e6b74ca893a011b8\",\"outcomeDesc\":\"24LoggerComponent::testLogger3\",\"type\":\"6\",\"recorded\":1498832900725}", "partition_key": "log", "row_key": "e6b74ca893a011b8" }, { "ts": 1498832900750, "value": { "id": "159dd15b2511848f69", "outcomeDesc": "25LoggerComponent::testLogger4", "type": "6", "recorded": 1498832900726 }, "$text": "{\"id\":\"159dd15b2511848f69\",\"outcomeDesc\":\"25LoggerComponent::testLogger4\",\"type\":\"6\",\"recorded\":1498832900726}", "partition_key": "log", "row_key": "159dd15b2511848f69" }, { "ts": 1498832900752, "value": { "id": "816716237d7b31398f", "outcomeDesc": "26LoggerComponent:: ERROR4 database offline", "type": "3", "recorded": 1498832900727 }, "$text": "{\"id\":\"816716237d7b31398f\",\"outcomeDesc\":\"26LoggerComponent:: ERROR4 database offline\",\"type\":\"3\",\"recorded\":1498832900727}", "partition_key": "log", "row_key": "816716237d7b31398f" }, { "ts": 1498832900754, "value": { "id": "13ffe10f791677a5e", "outcomeDesc": "27LoggerComponent:: WARN4 update called", "type": "4", "recorded": 1498832900728 }, "$text": "{\"id\":\"13ffe10f791677a5e\",\"outcomeDesc\":\"27LoggerComponent:: WARN4 update called\",\"type\":\"4\",\"recorded\":1498832900728}", "partition_key": "log", "row_key": "13ffe10f791677a5e" }, { "ts": 1498832900756, "value": { "id": "155d1100ed647cd7a0", "outcomeDesc": "28LoggerComponent::testLogger4", "type": "6", "recorded": 1498832900729 }, "$text": "{\"id\":\"155d1100ed647cd7a0\",\"outcomeDesc\":\"28LoggerComponent::testLogger4\",\"type\":\"6\",\"recorded\":1498832900729}", "partition_key": "log", "row_key": "155d1100ed647cd7a0" }, { "ts": 1498832900757, "value": { "id": "133e513d7db6fb16a28", "outcomeDesc": "30LoggerComponent::testLogger4", "type": "6", "recorded": 1498832900729 }, "$text": "{\"id\":\"133e513d7db6fb16a28\",\"outcomeDesc\":\"30LoggerComponent::testLogger4\",\"type\":\"6\",\"recorded\":1498832900729}", "partition_key": "log", "row_key": "133e513d7db6fb16a28" }, { "ts": 1498832900760, "value": { "id": "126c119b7a52665c0", "outcomeDesc": "31LoggerComponent::testLogger4", "type": "6", "recorded": 1498832900731 }, "$text": "{\"id\":\"126c119b7a52665c0\",\"outcomeDesc\":\"31LoggerComponent::testLogger4\",\"type\":\"6\",\"recorded\":1498832900731}", "partition_key": "log", "row_key": "126c119b7a52665c0" }, { "ts": 1498832900762, "value": { "id": "3b59c72d856d65e6", "outcomeDesc": "32LoggerComponent::testLogger4 982193023  details on submitting form; patient number 2984239423. 21312l3 123; sys update database input return 321kl3 note: 12 3123kj 21hkl31", "type": "6", "recorded": 1498832900732 }, "$text": "{\"id\":\"3b59c72d856d65e6\",\"outcomeDesc\":\"32LoggerComponent::testLogger4 982193023  details on submitting form; patient number 2984239423. 21312l3 123; sys update database input return 321kl3 note: 12 3123kj 21hkl31\",\"type\":\"6\",\"recorded\":1498832900732}", "partition_key": "log", "row_key": "3b59c72d856d65e6" }, { "ts": 1498832900763, "value": { "id": "ec213b6413c4410825", "outcomeDesc": "33LoggerComponent::testLogger4", "type": "6", "recorded": 1498832900732 }, "$text": "{\"id\":\"ec213b6413c4410825\",\"outcomeDesc\":\"33LoggerComponent::testLogger4\",\"type\":\"6\",\"recorded\":1498832900732}", "partition_key": "log", "row_key": "ec213b6413c4410825" }]

    beforeEach(function () {
        TestBed.configureTestingModule({
            imports: [HttpModule],
            providers: [
                EnvironmentService,
                {
                    provide: Http, useFactory: (backend, options) => {
                        return new Http(backend, options);
                    },
                    deps: [MockBackend, BaseRequestOptions]
                },
                MockBackend,
                BaseRequestOptions,
                LoggingApiService, ConfigService
            ]
        })

        // TestBed.configureTestingModule({
        //     imports: [HttpModule],
        //     providers: [LoggingApiService, ConfigService]
        // })
    })

    it('add log', inject([LoggingApiService], async (loggingApiService: LoggingApiService) => {
        loggingApiService.add("Info", "test message").subscribe(id => {
            expect(id.length).toBeGreaterThan(6)
        })
    }))

    it('get all logs', inject([LoggingApiService], async (loggingApiService: LoggingApiService) => {
        loggingApiService.add("Info", "test message").subscribe(id => {
            expect(id.length).toBeGreaterThan(6)
            loggingApiService.add("Info", "more text").subscribe(id2 => {
                expect(id2.length).toBeGreaterThan(6)
                // console.log('loggingApiService::add called|id:' + id)
                let options = { page: 1, pageSize: 4 }
                options['text'] = 'test'
                loggingApiService.get(options)
                    .subscribe(logData => {
                        // console.log(`loggingApiService::getAll called|logData.total:${JSON.stringify(logData.total)}|logData.items.length:${JSON.stringify(logData.items.length)}`)
                        expect(logData.total).toEqual(1)
                        expect(logData.items.length).toEqual(1)
                    })
            })
        })
    }))

    it('get all logs with paging', inject([LoggingApiService], async (loggingApiService: LoggingApiService) => {
        loggingApiService.add("Info", "test message1").subscribe(id =>
            loggingApiService.add("Info", "test message2").subscribe(id2 => {
                loggingApiService.add("Info", "test message3").subscribe(id3 => {
                    loggingApiService.add("Info", "more text").subscribe(id4 => {
                        expect(id.length).toBeGreaterThan(6)
                        expect(id2.length).toBeGreaterThan(6)
                        expect(id3.length).toBeGreaterThan(6)
                        expect(id4.length).toBeGreaterThan(6)
                        let options = { page: 2, pageSize: 2 }
                        loggingApiService.get(options)
                            .subscribe(logData => {
                                // console.log(`loggingApiService::getAll called|logData.total:${JSON.stringify(logData.total)}|logData.items.length:${JSON.stringify(logData.items.length)}|logData.items:${JSON.stringify(logData.items)}`)
                                expect(logData.total).toEqual(4)
                                expect(logData.items.length).toEqual(2)
                                expect(logData.items[0]['outcomeDesc']).toEqual('test message2')
                                expect(logData.items[1]['outcomeDesc']).toEqual('test message1')
                            })
                    })
                })
            })
        )
    }))

    it('get all logs with paging using sample data (ensure page 0 is page 1 and page 2 is not page 1)', inject([LoggingApiService], async (loggingApiService: LoggingApiService) => {
        loggingApiService.import(dataToImport)

        let options = { page: 0, pageSize: 4 }
        loggingApiService.get(options)
            .subscribe(logData => {
                expect(logData.total).toEqual(32)
                // console.log(`loggingApiService::getAll called|logData.total:${JSON.stringify(logData.total)}|logData.items.length:${JSON.stringify(logData.items.length)}|logData.items:${JSON.stringify(logData.items)}`)
                options = { page: 1, pageSize: 4 }
                loggingApiService.get(options)
                    .subscribe(logData2 => {
                        // console.log(`loggingApiService::getAll called|logData.total:${JSON.stringify(logData.total)}|logData.items.length:${JSON.stringify(logData.items.length)}|logData.items:${JSON.stringify(logData.items)}`)
                        expect(logData2.total).toEqual(32)
                        expect(logData.items).toEqual(logData2.items)
                        options = { page: 3, pageSize: 4 }
                        loggingApiService.get(options)
                            .subscribe(logData3 => {
                                // console.log(`loggingApiService::getAll called|logData.total:${JSON.stringify(logData.total)}|logData.items.length:${JSON.stringify(logData.items.length)}|logData.items:${JSON.stringify(logData.items)}`)
                                expect(logData3.total).toEqual(32)
                                expect(logData3.items).not.toEqual(logData2.items)
                            })
                    })
            })
    }))

    afterEach(function () {
        TestBed.resetTestingModule()
    })
})
