import { HostListener, Component, OnInit, Inject } from '@angular/core'
import { MessageService } from 'primeng/components/common/messageservice'
import { ErrorService } from '../../core/error-messages/error.service'
import { SearchApiService } from '../../core/search/search-api.service'
import { MainContent } from '../maincontent/maincontent'
import { Product } from '../maincontent/product'

@Component({
  selector: 'app-homepage',
  templateUrl: './homepage.component.html',
  styleUrls: ['./homepage.component.css']
})
export class HomepageComponent implements OnInit {
  public quickContactData: Array<string> = []
  public quickUpdatesData: Array<string> = []
  public quickNewsData: Array<string> = []
  searchBoxDataSource: string
  maincontent: MainContent

  constructor(private error: ErrorService,
    public searchApiService: SearchApiService,
    private messageService: MessageService) {
    this.searchBoxDataSource = 'contacts'
  }

  async ngOnInit() {
    // TODO replace with data source
    // this.searchApiService.sample({ datasource: 'contacts', count: 9 })
    //   .subscribe(results => this.quickContactData = results)
    // this.searchApiService.sample({ datasource: 'updates', count: 5 })
    //   .subscribe(results => this.quickUpdatesData = results)
    // this.searchApiService.sample({ datasource: 'news', count: 3 })
    //  .subscribe(results => this.quickNewsData = results)


  }

  errorPopup() {
    this.error.setErrorCode("", "stack trace error: very long error trace and detailed information.!!!!!!!!!!!!!!!");
  }

  contentUpdate(data: any) {
    this.maincontent = data
  }

  save() {
    console.warn("Function not implemented")
  }

}
