import { Component, OnInit, Input, ElementRef,
  ViewChild, Renderer, HostListener } from '@angular/core'
import { Observable, Subscription } from 'rxjs/Rx'
import { ExtLinkService } from '../ext-link.service'
import { ExtLink } from '../ext-link'
import { TimerObservable } from "rxjs/observable/TimerObservable"
import { ConfigService } from '../../../core/config/config.service'
import { LoggerService } from '../../../core/logger/logger.service'

@Component({
    selector: 'app-ext-link-modal',
    templateUrl: './ext-link-modal.component.html',
    styleUrls: ['./ext-link-modal.component.css']
})

export class ExtLinkModalComponent implements OnInit {
  href = ''
  blanktext = ''
  sitename = ''
  title = ''
  blank = false
  readTime = 20

  secondsConfigured: number
  seconds: number
  localDomains: Array<string>
  @ViewChild('xlinkGo') xlinkGo: any
  @ViewChild('xlinkCancel') xlinkCancel: any
  @ViewChild('xlinkClose') xlinkClose: any
  clickTimer: Observable<number>
  clickTimerSubscription: Subscription

  constructor(
    private configService: ConfigService,
    private extLinkService: ExtLinkService,
    private loggerService: LoggerService,
    private ef: ElementRef,
    private renderer: Renderer) { }

  ngOnInit() {
    this.href = ''

    this.configService.load(["secondsForExternalRedirect", "localDomains"])
      .subscribe(config => {
        this.secondsConfigured = config.secondsForExternalRedirect
        this.localDomains = config.localDomains
    })

    this.extLinkService.extLink.subscribe(extLink => {
      this.open(extLink)
    })
  }

  open(el: ExtLink) {
    this.href = el.href
    this.blanktext = el.blanktext
    this.sitename = el.sitename
    this.title = el.title

    if (el.blank) {
      this.blank = el.blank
    } else {
      this.blank = false
    }

    if (typeof this.clickTimerSubscription !== 'undefined' && typeof this.clickTimerSubscription.unsubscribe === 'function') {
      this.clickTimerSubscription.unsubscribe()
    }
    this.clickTimer = TimerObservable.create(1000, 1000)
    this.seconds = this.secondsConfigured
    this.readTime = this.secondsConfigured - 4 // minus a little time for reading
    this.clickTimerSubscription = this.clickTimer.subscribe((t: any) => {
      this.seconds--
      if (this.seconds < 1) {
        this.killTimer()
        this.go()
      }
    })

    setTimeout(() => {
      if (this.xlinkGo) {
        this.renderer.invokeElementMethod(this.xlinkGo.nativeElement, 'focus')
      }
    }, 200)

  }

  killTimer() {
    try {
      this.seconds = 0
      if (typeof this.clickTimerSubscription !== 'undefined' && typeof this.clickTimerSubscription.unsubscribe === 'function') {
        this.clickTimerSubscription.unsubscribe()
      }
    } catch (ex) {
      this.loggerService.debug(`ex:${JSON.stringify(ex)}`)
    }
  }

  get plural(): string {
    return this.seconds === 1 ? "" : "s"
  }

  modalClick(event: any) {
    event.preventDefault()

    // handle IE click-through modal bug
    event.stopPropagation()
    this.goFocus(null)
  }

  cancel(): void {
    this.extLinkService.close()
    this.killTimer()
  }

  go(): void {

    if (!this.blank) {
      window.open(this.href, "_blank")
    } else {
      let blankWin = window.open("", "_blank")
      blankWin.document.write("<h1>" + this.blanktext + "</h1>")
    }
    this.cancel()
  }

  closeFocus(event) {
    event.preventDefault()
    setTimeout(() => {
      this.renderer.invokeElementMethod(this.xlinkClose.nativeElement, 'focus')
    }, 100)
  }

  cancelFocus(event) {
    event.preventDefault()
    setTimeout(() => {
      if (this.xlinkCancel) {
        this.renderer.invokeElementMethod(this.xlinkCancel.nativeElement, 'focus')
      }
    }, 100)
  }

  goFocus(event) {
    if (event) {
      event.preventDefault()
    }
    setTimeout(() => {
      if (this.xlinkGo) {
        this.renderer.invokeElementMethod(this.xlinkGo.nativeElement, 'focus')
      }
    }, 100)
  }

}
