import { Injectable } from '@angular/core'
import { Http, Response } from '@angular/http'
import { Observable, Subject } from "rxjs/Rx"
import { ExtLink } from './ext-link'

@Injectable()
export class ExtLinkService {
  public extLink: Observable<ExtLink>
  _linkSubject: Subject<ExtLink>

  constructor(private http: Http) {
    this._linkSubject = new Subject<ExtLink>()
    this.extLink = this._linkSubject.asObservable()
  }

  public open(extLink: ExtLink) {
    this._linkSubject.next(extLink)
  }

  public close() {
    let el = new ExtLink()
    this._linkSubject.next(el)
  }

}
