import {
    Component,
    OnInit,
    Input,
    ViewChild,
    Renderer,
} from '@angular/core';
import { ErrorMessage } from '../error-message';
import { ErrorService } from '../error.service';

@Component({
    selector: 'app-error-modal',
    templateUrl: './error-modal.component.html',
    styleUrls: ['./error-modal.component.css']
})
export class ErrorModalComponent implements OnInit {
    errorMessage: ErrorMessage
    step = 'start'
    @ViewChild('errCloseButton') errCloseButton: any

    constructor(private errorService: ErrorService, private renderer: Renderer) { }

    ngOnInit() { }

    public close() {
        this.errorService.clear();
        this.step = 'start'
    }

    @Input()
    set appError(err: ErrorMessage) {

        if (typeof err === "undefined") {
            return
        }

        this.errorMessage = err

        if (err != null) {
            setTimeout(() => {
                this.renderer.invokeElementMethod(this.errCloseButton.nativeElement, 'focus')
            }, 100)
        }

    }

    public notify() {
        // this.step = 'notified';

        // TODO call email service to send meaasge !!!!!!!!!!!!!
        // if email success     this.step = 'notified';
        // if email failed
        this.step = 'clipboard';
    }

    public copy() {
        console.log(" copy !!!!!!!!!!!!!!!!!!!!!");
    }


}
