import { fakeAsync,
        async,
        tick,
        getTestBed,
        discardPeriodicTasks,
        ComponentFixture,
        TestBed } from '@angular/core/testing'
import * as Axe from 'axe-core'
import { HttpModule} from "@angular/http"
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../../karma/karma-helper'
import { ClipboardModule } from 'ngx-clipboard'

import { ErrorModalComponent } from './error-modal.component'
import { ErrorService } from '../error.service'
import { ErrorMessage } from '../error-message';

describe('ErrorModalComponent', () => {
  let component: ErrorModalComponent
  let fixture: ComponentFixture<ErrorModalComponent>

  beforeEach(async(() => {

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        HttpModule,
        ClipboardModule
      ],
      declarations: [
        ErrorModalComponent
      ],
      providers: [
        ErrorService
      ]
    }).compileComponents()

  }))

  afterEach(function () {
      TestBed.resetTestingModule()
  })

  it('start div should have no accessibility issues', fakeAsync(() => {
    let res: Axe.AxeResults
    let fixt: ComponentFixture<ErrorModalComponent> = getTestBed()
                    .createComponent(ErrorModalComponent)
    let comp = fixt.componentInstance
    let errMess = new ErrorMessage()
    errMess.code = "777"
    errMess.messageTechnical = "lucky you"
    comp.ngOnInit()
    tick()
    comp.errorMessage = errMess
    fixt.detectChanges()
    //  console.error(" @@1@@@@@@@@@@@@@@@@@@ doc="+document.body.innerHTML)

    tick()
    Axe.run(document, KarmaHelper.axeOptions(), (error, result) => {
      this.res = result
      if (error) {
        console.error(error)
      }
    })
    tick()

    KarmaHelper.axeViolationLog(this.res)
    expect(this.res.violations.length).toEqual(0)

    tick()
    discardPeriodicTasks()

  }))


  it('notified div should have no accessibility issues', fakeAsync(() => {
    let res: Axe.AxeResults
    let fixt: ComponentFixture<ErrorModalComponent> = getTestBed()
                    .createComponent(ErrorModalComponent)
    let comp = fixt.componentInstance

    let errMess = new ErrorMessage()
    errMess.code = "777"
    errMess.messageTechnical = "lucky you"
    comp.step = "notified"
    comp.ngOnInit()
    comp.errorMessage = errMess
    fixt.detectChanges()

    tick()
    Axe.run(document, KarmaHelper.axeOptions(), (error, result) => {
      this.res = result
      if (error) {
        console.error(error)
      }
    })

    tick()
    KarmaHelper.axeViolationLog(this.res)
    expect(this.res.violations.length).toEqual(0)

    tick()
    discardPeriodicTasks()
  }))

  it('clipboard div should have no accessibility issues', fakeAsync(() => {
    let res: Axe.AxeResults
    let fixt: ComponentFixture<ErrorModalComponent> = getTestBed()
                    .createComponent(ErrorModalComponent)
    let comp = fixt.componentInstance

    let errMess = new ErrorMessage()
    errMess.code = "777"
    errMess.messageTechnical = "lucky you"
    comp.step = "clipboard"
    comp.ngOnInit()
    comp.errorMessage = errMess
    fixt.detectChanges()
    //  console.error(" @@@@@@@@@@@@@@@@@@@@ doc="+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions(), (error,result) => {
      this.res = result
      if(error) {
        console.error(error)
      }
    })

    tick()
    KarmaHelper.axeViolationLog(this.res)
    expect(this.res.violations.length).toEqual(0)
    tick()
    discardPeriodicTasks()

  }))


})
