import { Injectable } from '@angular/core'
import { Http, Response } from '@angular/http'
import { Observable } from 'rxjs/Rx'

declare var global

/*
* environment variables must be loaded from /assets json file because
* CI build overwrites vars for each deployment to the many VA systems.
*/
@Injectable()
export class EnvironmentService {
  environment: any
  production: boolean

  constructor(private http: Http) { }

  set(env) {
    this.environment = env
  }

  getEnv(): Observable<any> {
    return Observable.create(observer => {
      if (this.environment) {
        console.log('EnvironmentService', 'ALREADY CACHED')
        observer.next(this.environment)
        observer.complete()
        return
      }
      console.log(`SHOWME|global['it']`, global['it'])
      if (typeof global['it'] !== 'undefined') {
        this.environment = this.loadMockData()
        observer.next(this.environment)
        observer.complete()
        return
      }
      this.http.get('../../assets/config/environment.json')
        .map(res => res.json())
        .catch(this.handleError)
        .subscribe(environment => {
          this.environment = environment
          observer.next(this.environment)
          observer.complete()
        })
    })
  }

  public loadMockData() {
    return {
      "production": false,
      "enable_api": false
    }
  }

  private handleError(error: Response) {
    console.error(error);
    return Observable.throw(typeof error.json === "function" ? error.json().error : error.toString() || 'EnvironmentService Error');
  }
}
