import {async, inject, TestBed} from '@angular/core/testing';
import {MockBackend, MockConnection} from '@angular/http/testing';
import {EnvironmentService} from './environment.service';
import {BaseRequestOptions, Connection, Http, Response, ResponseOptions} from '@angular/http';

describe('MenusService', function () {
  let service: EnvironmentService;
  let backend: MockBackend;
  let lastConnection: Connection;

  beforeEach(function () {

    TestBed.configureTestingModule({
      providers: [
        EnvironmentService,
        MockBackend,
        BaseRequestOptions,
        {
          provide: Http,
          useFactory: function (mockBackend, defaultOptions) {
            return new Http(mockBackend, defaultOptions);
          },
          deps: [MockBackend, BaseRequestOptions]
        }
      ]
    });

  });

  beforeEach(inject([EnvironmentService, MockBackend], function (EnvironmentService, mockBackend) {
    service = EnvironmentService;
    backend = mockBackend;
    backend.connections.subscribe((connection: any) => lastConnection = connection);
  }));

  it('should construct', async(inject(
    [EnvironmentService, MockBackend], (serv, mockBackend) => {

      expect(serv).toBeDefined();
    })));

  // it('should query current service url', () => {
  //   service.getEnv();
  //   expect(lastConnection).toBeDefined('no http service connection at all?');
  // });

  it('should get data', function (done) {

    backend.connections.subscribe(function (connection: MockConnection) {

      let options = new ResponseOptions(
        {body:
        {
          "production": false,
          "appsInsightsOn": false,
          "appInsights": {
            "instrumentationKey": "0d643855-1b1d-4980-8339-6b45791db97f"
          },
          "iamPermissionsUrl": "",
          "enable_api": false,
          "fhirUrl": "http://54.205.202.143:9080",
          "einsuranceSiteParamsUrl": "",
          "coreAPI": "http://localhost:8193/api/v1"
        }
      }
      );
      connection.mockRespond(new Response(options));
    });

    service.getEnv().subscribe(function (response) {
        expect(response['production']).toEqual(false);
      },
      function (e) {
        fail(e);
      }
    );

    done();
  });

  afterEach(function () {
    TestBed.resetTestingModule();
  });

});
