export class Tokenization {
    data: any

    constructor(data) {
        this.data = data
    }

    dump() {
        return this.data
    }

    terms() {
        return Object.keys(this.data)
    }

    scan(text) {
        let k = Object.keys(this.data[text].spread).map(_ => parseInt(_))
        k.sort((a, b) => {
            if (a < b) return 1
            if (a > b) return -1
            return 0
        })
        return k
    }

    top(text) {
        const scanned = this.scan(text)
        const item = this.data[text].spread[scanned[0]]
        if (typeof item === 'undefined') {
            return undefined
        }
        return item.value
    }

    all(text) {
        const scanned = this.scan(text)
        const keys = this.data[text].spread
        let results = []
        for (let n in keys) {
            let i = 0
            let value
            let v = parseInt(keys[n])
            value = keys[n]
            results.push(value.value)
            let next = value.next
            while (typeof next !== 'undefined') {
                value = next
                next = value.next
                results.push(value.value)
            }
            value.next = next
        }
        return results
    }

    filter(expression) {
        if (typeof expression !== 'function') {
            return []
        }
        const self = this
        const filtered = this.terms()
            .filter(expression)
            .sort((a, b) => {
                if (self.data[a].sum < self.data[b].sum) return 1
                if (self.data[a].sum > self.data[b].sum) return -1
                return 0
            })
            .reduce((result, key) => {
                result[key] = self.data[key]
                return result
            }, {})
        return filtered
    }

    highlight(term, text, render) {
        const re = new RegExp("\\b" + term + "\\b", 'gi')
        const replacement = render.replace('{{_}}', term)
        return text.replace(re, replacement)
    }
}