export class IdGen {
    static generate(seed?: string): string {
        const netSeed = (seed || '') + (new Date()).toISOString()
        let sum = 0
        for (const n of netSeed) {
            sum += n.charCodeAt(0)
        }
        const genSegment = () => Math.floor((sum + (+(new Date()))) * 100000).toString(16)
        return genSegment() + genSegment() + genSegment() + genSegment()
    }
}