import { Headers, Http, Response } from '@angular/http'

import { Injectable } from '@angular/core'
import { Observable } from 'rxjs/Observable'

import { EnvironmentService } from '../../core/env/environment.service'

import { LogLevel } from '../logger/log-level'
// import { Config } from './config'

@Injectable()
export class ConfigService {
    private config = {}
    private url: string
    private headers = new Headers({ 'Authorization': 'Bearer ABCD' })

    constructor(private http: Http, private env: EnvironmentService) {
    }

    public update(name: string, value: any): Observable<Response> {
        return Observable.create(observer => {
            const environment = this.env.getEnv()
            this.env.getEnv()
                .subscribe(environment => {
                    this.http.put('/api/core/v2/config/' + name, { value: JSON.stringify(value) }, { headers: this.headers })
                        .catch(this.handleError)
                        .subscribe(result => {
                            observer.next()
                            observer.complete()
                        })
                })
        })
    }

    public load(requested: Array<string>): Observable<any> {
        const cherryPick = (config, array) => {
            let obj = {}
            array.map(p => {
                if (p in config) {
                    obj[p] = config[p]
                }
            })
            return obj
        }
        return Observable.create(observer => {
            const cached = cherryPick(this.config, requested)
            console.log('ConfigService->cherryPick~cached', cached)
            if (Object.keys(cached).length === requested.length) {
                console.log('ConfigService', 'ALREADY CACHED')
                observer.next(cached)
                observer.complete()
                return
            }
            this.env.getEnv()
                .subscribe(environment => {
                    console.log('ConfigService->environment', environment)
                    const missing = requested.filter(p => typeof cached[p] === 'undefined')
                    console.log('ConfigService->missing', missing)
                    const parameter = missing.join(',')
                    if (environment.enable_api === true) {
                        this.http
                            .get('/api/core/v2/config/' + parameter, { headers: this.headers })
                            .map(response => {
                                return response.json()
                            })
                            .catch(this.handleError)
                            .subscribe(results => {
                                this.config = Object.assign({}, this.config, results)
                                const result = cherryPick(this.config, requested)
                                console.log('ConfigService->result', result)
                                observer.next(result)
                                observer.complete()
                            })
                    } else {
                        this.config = {
                            "menus": [{ "title": "eInsurance", "uri": "einsurance/home" }, { "title": "ePharmacy", "uri": "epharmacy/home" }, { "title": "eBilling", "uri": "ebilling/home" }, { "title": "ePayments", "uri": "epayments/home" }, { "title": "Non-MCCF", "uri": "non-mccf/home" }, { "title": "NPI", "uri": "npi/home" }, { "title": "eAdmin", "uri": "eadmin/home" }],
                            "tooltips": { "search": "Enter search term.", "contact-search": "Click to search contacts.", "site-wide-search": "Click to search site.", "phone": "Enter a phone number.", "rte": "Rich text editor", "emailtitle": "Enter email title.", "email": "Enter email address.", "erevenueurl": "Enter eRevenue URL.", "cancel": "Click cancel to discard changes.", "save": "Click to save changes." },
                            "secondsForExternalRedirect": 20,
                            "localDomains": "['http://DNS/']",
                            "logLevel": "Info",
                            "products": [{ "name": "home", "erevenueUrl": "https://DNS.URL/sites/eBusinessSolutions/SitePages/Home.aspx" }, { "name": "eBilling", "erevenueUrl": "https://DNS.URL/sites/eBusinessSolutions/SitePages/Home.aspx" }, { "name": "eInsurance", "erevenueUrl": "https://DNS.URL/sites/eBusinessSolutions/SitePages/Home.aspx" }, { "name": "ePharmacy", "erevenueUrl": "https://DNS.URL/sites/eBusinessSolutions/SitePages/Home.aspx" }, { "name": "ePayments", "erevenueUrl": "https://DNS.URL/sites/eBusinessSolutions/SitePages/Home.aspx" }, { "name": "NPI", "erevenueUrl": "https://DNS.URL/sites/eBusinessSolutions/SitePages/Home.aspx" }, { "name": "Non-MCCF", "erevenueUrl": "https://DNS.URL/sites/eBusinessSolutions/SitePages/Home.aspx" }],
                            "site-wide:help": "help line 1<br> help line2<br> <p>dial <b>9-1-1</b> for an emergency</p><br><I>Thank you!</I>",
                            "ebilling:help": "eBilling!!! !!!! !!!!",
                            "epharmacy:help": "ePharmacy !!! !!!! !!!!",
                            "non-mccf:help": " Non-MCCF !!! !!!! !!!!",
                            "epayments:help": " ePayment  !!! !!!! !!!!",
                            "npi:help": " NPI !!! !!!! !!!!",
                            "einsurance:help": " eInsurance !!! !!!! !!!!",
                            "contact": { "phone": "(PII", "emailText": "PII                      ", "emailValue": "PII                      " },
                            "accessRoles": ["SBTEST_WRITER"]
                        }
                        const result = cherryPick(this.config, requested)
                        observer.next(result)
                        observer.complete()
                    }
                })
        })
    }

    handleError(err: any) {
        console.log('sever error:', err)  // debug
        if (err instanceof Response) {
            return Observable.throw(this.getErrorMessage(err))
        }
        return Observable.throw(err || 'backend server error')
    }

    getErrorMessage(err) {
        let error = err.json()
        if (typeof error === 'object' && error.resourceType === 'OperationOutcome' && error.issue && error.issue[0]) {
            return {
                errorCode: 504, // VA-FHIR-Server error
                message: error.issue[0].diagnostics || 'VA-FHIR-Server Error - unknown'
            }
        } else {
            return err.error || 'unknown server error'
        }
    }
}
