import { Injectable } from '@angular/core'
import { Crumb } from './crumb'

const HOME_LABEL = "MCCF EDI TAS Portal Home Page"

@Injectable()
export class BreadcrumbService {
  crumbs: Array<Crumb>

  constructor() {
    this.crumbs = []
  }

  public push(crumb: Crumb) {
    if (!this.hasCrumb(crumb)) {
      this.crumbs.push(crumb)
    }
  }

  public hasCrumb(crumb: Crumb): boolean {
    let popIndex = 0
    for (let i = 0; i < this.crumbs.length; i++) {
      if (crumb.path === this.crumbs[i].path) {
        popIndex++
      }
    }

    for (let i = 0; i < popIndex; i++) {
      this.crumbs.pop()
    }

    return popIndex > 0
  }

  public reset() {
    this.crumbs = []
    let crumb = new Crumb()
    crumb.label = HOME_LABEL
    crumb.url = ""
    crumb.path = ""
    this.crumbs.push(crumb)
  }

}
