import { TestBed, async, inject } from '@angular/core/testing'
import { MockBackend } from '@angular/http/testing'
import { BreadcrumbService } from './breadcrumb.service'
import { Crumb } from './crumb'

describe('BreadcrumbService', () => {

  beforeEach(() => {
    TestBed.configureTestingModule({
      providers: [BreadcrumbService]
    })
  })

  it('should reset',
    inject([BreadcrumbService], (breadcrumbService) => {
      let bread = breadcrumbService
      bread.reset()
      expect(bread.crumbs.length).toEqual(1)
  }))

  it('should push crumbs', () => {
    let breadcrumb = new BreadcrumbService()

    breadcrumb.reset()

    let crumb = new Crumb()
    crumb.label = "test main"
    crumb.path = "main"
    crumb.url = "/main"
    breadcrumb.push(crumb)

    let crumb2 = new Crumb()
    crumb2.label = "sub page"
    crumb2.path = "sub"
    crumb2.url = "/home/subpage"
    breadcrumb.push(crumb2)

    expect(breadcrumb.crumbs.length).toEqual(3)
  })

  it('should pop crumb', () => {
    let breadcrumb = new BreadcrumbService()

    breadcrumb.reset()

    let crumb = new Crumb()
    crumb.label = "test main"
    crumb.path = "main"
    crumb.url = "/main"
    breadcrumb.push(crumb)

    let crumb2 = new Crumb()
    crumb2.label = "sub page"
    crumb2.path = "sub"
    crumb2.url = "/home/subpage"
    breadcrumb.push(crumb2)

    // duplicate should pop
    let crumb3 = new Crumb()
    crumb3.label = "test main"
    crumb3.path = "main"
    crumb3.url = "/main"
    breadcrumb.push(crumb3)

    expect(breadcrumb.crumbs.length).toEqual(2)
  })

})
