import { Injectable } from '@angular/core'
import { BehaviorSubject, Observable } from "rxjs/Rx"
import { ConfigService } from '../config/config.service'

@Injectable()
export class AuthService {
  idSubject = new BehaviorSubject<string>('')
  logoutUrl = "https://WhatIsTheSiteminderLogoutURL?"
  admin = new BehaviorSubject<boolean>(false)

  constructor(private configService: ConfigService) {}

  getAuthSession() {

    if (document.cookie.indexOf("IAMSESSION=") === -1) {
      console.error("IAMSESSION not found")
      return
    }

    this.configService.load(["accessRoles"])
        .subscribe(config => {
          console.log('@@@@@@@@  config.accessRoles:' + config.accessRoles)
          if (config.accessRoles.includes("ADMIN")) {
            this.admin.next(true)
            this.idSubject.next("Admin User") // TODO fix
          } else {
            this.admin.next(false)
            this.idSubject.next("Normal User")  // TODO fix
          }
        })

    // TODO parse perms from headers !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // this.idSubject.next(document.cookie.substring(0, 18))
    // let id = document.cookie.substring(document.cookie.indexOf("=") + 1, document.cookie.length)
    // this.idSubject.next(id)

  }

  isAdmin(): Observable<boolean> {
    return this.admin
  }

  fakeadmin() {
    // TODO take out fake admin !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    let fake = this.admin.value
    if (fake) {
      this.admin.next(false)
      this.idSubject.next("Normal User")
    } else {
      this.admin.next(true)
      this.idSubject.next("Admin User")
    }
  }

  logout() {
    this.idSubject.next('')
    window.location.href = this.logoutUrl
  }

}
