import { Http, Response } from '@angular/http'

import { ConfigService } from './config/config.service'
import { EnvironmentService } from './env/environment.service'

const PRELOADED_CONFIG = [
    "menus",
    "tooltips",
    "secondsForExternalRedirect",
    "localDomains",
    "logLevel"
]

export function appInit(http: Http, environmentService: EnvironmentService, configService: ConfigService): () => Promise<any> {
    return (): Promise<any> => {
        return new Promise((resolve, reject) => {
            console.log('INIT CALLED')
            environmentService.getEnv()
                .subscribe(environment => {
                    configService.load(PRELOADED_CONFIG)
                        .subscribe(config => {
                            console.log('INIT DONE')
                            resolve()
                        })
                })
        })
    }
}