import { ModuleWithProviders } from '@angular/core'
import { Routes, RouterModule } from '@angular/router'
import { HomepageComponent } from './core/homepage/homepage.component'
import { SearchComponent } from './core/search/search.component'
import { AdminGuard } from './core/authentication/admin.guard'
import { NotFoundComponent } from './core/not-found/not-found.component'

const routes: Routes = [
  { path: '',
    redirectTo: 'home',
    pathMatch: 'full'
  },
  { path: 'home',
    component: HomepageComponent,
  },
  { path: 'search/:val',
    component: SearchComponent },
  { path: 'common',
    loadChildren: 'app/mccf-common/mccf-common.module#MccfCommonModule'},
  { path: 'results',
    loadChildren: 'app/mccf-search/mccf-search.module#MccfSearchModule'},
  { path: 'epayments',
    loadChildren: 'app/mccf-epayment/mccf-epayment.module#MccfEpaymentModule'},
  { path: 'epharmacy',
    loadChildren: 'app/mccf-epharmacy/mccf-epharmacy.module#MccfEpharmacyModule'},
  { path: 'einsurance',
    loadChildren: 'app/mccf-einsurance/mccf-einsurance.module#MccfEinsuranceModule'
  },
  { path: 'ebilling',
    loadChildren: 'app/mccf-ebilling/mccf-ebilling.module#MccfEbillingModule'},
  { path: 'non-mccf',
    loadChildren: 'app/mccf-non-mccf/mccf-non-mccf.module#NonMccfModule'},
  { path: 'npi',
    loadChildren: 'app/mccf-npi/mccf-npi.module#MccfNpiModule'},
  { path: 'eadmin',
    loadChildren: 'app/mccf-eadmin/mccf-eadmin.module#MccfEadminModule'},
  { path: 'system',
    canActivate: [AdminGuard],
    loadChildren: 'app/mccf-system/mccf-system.module#MccfSystemModule'
  },
  { path: '**', component: NotFoundComponent }
];

export const routing: ModuleWithProviders = RouterModule.forRoot(routes);
