import { BrowserModule } from '@angular/platform-browser'
import { NoopAnimationsModule } from '@angular/platform-browser/animations'
import { GrowlModule } from 'primeng/primeng'
import { ScheduleModule } from 'primeng/primeng'
import { NgModule, ErrorHandler, APP_INITIALIZER } from '@angular/core'
import { FormsModule, ReactiveFormsModule } from '@angular/forms'
import { HttpModule, Http } from '@angular/http';

import { AppComponent } from './app.component'
import { routing } from './app.routing'
import { HomepageComponent } from './core/homepage/homepage.component'
import { NotFoundComponent } from './core/not-found/not-found.component'
import { ErrorModalComponent } from './core/error-messages/error-modal/error-modal.component'
import { ExtLinkModalComponent } from './core/ext-link/modal/ext-link-modal.component'
import { ErrorService } from './core/error-messages/error.service'
import { ClipboardModule } from 'ngx-clipboard'

import { GlobalErrorHandler } from './global.error-handler'
import { ConfigService } from './core/config/config.service'
import { BreadcrumbService } from './core/breadcrumb/breadcrumb.service'
import { ExtLinkService } from './core/ext-link/ext-link.service'
import { LoggerService } from './core/logger/logger.service'
import { LoggingApiService } from './core/logger/logging-api.service'
import { SearchApiService } from './core/search/search-api.service'
import { MccfCommonModule } from './mccf-common/mccf-common.module'
import { MccfSearchModule } from './mccf-search/mccf-search.module'
import { SearchComponent } from './core/search/search.component'
import { appInit } from './core/appinit'
import { EnvironmentService } from './core/env/environment.service'
import { AuthService } from './core/authentication/auth.service'
import { AdminGuard } from './core/authentication/admin.guard'
import { TasHttp } from './core/tasHttp/tas-http.service'
import { MenusService } from "./core/menus/menus.service"
import { TooltipsService } from "./mccf-common/tooltips/tooltips.service"
import { MainContentService } from "./core/maincontent/maincontent.service"
import { MessageService } from "primeng/components/common/messageservice"
import { IamRecordService } from "./mccf-system/service/iam.service"
import { ProgressBarModule } from 'primeng/primeng'
import { CalendarComponent } from './core/calendar/calendar.component'
import { AccordionModule } from 'primeng/primeng'
import { TabViewModule } from 'primeng/primeng'
import { CodeHighlighterModule } from 'primeng/components/codehighlighter/codehighlighter'

@NgModule({
  declarations: [
    AppComponent,
    HomepageComponent,
    NotFoundComponent,
    ErrorModalComponent,
    SearchComponent,
    CalendarComponent,
    ExtLinkModalComponent
  ],
  imports: [
    BrowserModule,
    NoopAnimationsModule,
    GrowlModule,
    ScheduleModule,
    FormsModule,
    ReactiveFormsModule,
    ClipboardModule,
    HttpModule,
    routing,
    MccfCommonModule,
    MccfSearchModule,
    ProgressBarModule,
    AccordionModule
  ],
  providers: [
    ErrorService,
    MenusService,
    IamRecordService,
    TooltipsService,
    MainContentService,
    MessageService,
    ConfigService,
    LoggerService,
    LoggingApiService,
    SearchApiService,
    EnvironmentService,
    AuthService,
    AdminGuard,
    BreadcrumbService,
    ExtLinkService,
    {
      provide: APP_INITIALIZER,
      useFactory: appInit,
      multi: true,
      deps: [Http, EnvironmentService, ConfigService]
    },
    // { provide: ErrorHandler, useClass: GlobalErrorHandler },
    { provide: Http, useClass: TasHttp }
  ],
  bootstrap: [AppComponent]
})
export class AppModule { }
