import { Component,
        OnInit,
        ViewChild,
        Renderer,
        ViewEncapsulation} from '@angular/core'
import { Router, NavigationEnd } from '@angular/router'
import { Title } from '@angular/platform-browser'
import { MenusService } from './core/menus/menus.service'
import { MainContentService } from './core/maincontent/maincontent.service'
import { Menu } from './core/menus/menu'
import { MainContent } from './core/maincontent/maincontent'
import { ErrorService } from './core/error-messages/error.service'
import { ErrorMessage } from './core/error-messages/error-message'
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { Observable } from "rxjs/Rx"

import { ConfigService } from './core/config/config.service'
// import { Config } from './core/config/config'
import {
  BrowserConsoleOutputProvider,
  ILogMessage,
  LoggerService,
  LogLevel
} from './core/logger/logger.service'

import { LoggingApiService } from './core/logger/logging-api.service'
import { Data } from './core/database/data'
import { MemoryDbVariableMode } from './core/database/memorydb'
import { MessageService } from "primeng/components/common/messageservice";
import { EnvironmentService } from './core/env/environment.service'
import { AuthService } from './core/authentication/auth.service'

const TITLE = 'eBusiness Solutions'
const COMMON_URL = 'common'

@Component({
  selector: 'app-root',
  encapsulation: ViewEncapsulation.None,
  styleUrls: [
    '../assets/css/tas-custom.css',
    '../assets/uswds/css/uswds.css',
    './app.component.css',
    '../assets/font-awesome-4.7.0/css/font-awesome.css',
    '../assets/primeng/resources/themes/tas-core/theme.css',
    '../assets/primeng/resources/primeng.min.css',
    '../assets/css/quill.snow.css',
    '../assets/css/datatables.css',
    '../assets/css/jquery.dataTables.min.css'
  ],
  templateUrl: './app.component.html'
})

export class AppComponent implements OnInit {
  searchGroup: FormGroup
  loginId: Observable<string>
  isAdmin: Observable<boolean>
  search: string
  product = 'home'
  productLink = '?'
  maincontentService: MainContentService
  messageService: MessageService
  errorMessage = ''
  appError: ErrorMessage
  menus: Menu[]
  maincontent: MainContent
  _data: Data

  // fix for USWDS bug - hidden menu items getting focus
  // https://github.com/18F/web-design-standards/issues/2257
  menuOpen = true

  constructor(private env: EnvironmentService,
    private menuService: MenusService,
    private errorService: ErrorService,
    private router: Router,
    private titleService: Title,
    private loggingApiService: LoggingApiService,
    private loggerService: LoggerService,
    private configService: ConfigService,
    private mcService: MainContentService,
    private messService: MessageService,
    private authService: AuthService,
    private renderer: Renderer) {
    // TODO this.messageService = messService is not being used, why is this here DJH 11/2?
    this.messageService = messService
    this.maincontentService = mcService
    this._data = new Data(new MemoryDbVariableMode())
    errorService.errorCode$.subscribe(newErr => this.appError = newErr);
    console.log("AppComponent::.ctor")

    this.env.getEnv()
      .subscribe(environment => {
        this.configService.load(["logLevel"])
          .subscribe(config => {
            const enable_api = environment.enable_api
            console.log('>>>>>>>>>>>>>>>>>>>>>>>logLevel', config.logLevel)
            this.loggerService.setlogLevel(LogLevel[<string>config.logLevel])
            this.router.events.subscribe((val) => {
              this.loggerService.info(val.toString())
            })

            if (enable_api === true) {
              console.log('Logging is on')
              this.loggerService.setOutputProvider((data: ILogMessage): void => {
                BrowserConsoleOutputProvider(data)
                this.loggingApiService.add(data.level.toString(), data.message)
                  .subscribe(id => {
                    console.log('loggingApiService::add called|id:' + id)
                    let options = { page: 1, pageSize: 4 }
                    options['text'] = 'urlAfterRedirects'
                    // this.loggingApiService.get(options)
                    //   .subscribe(logData => {
                    //     console.log(`loggingApiService::getAll called|logData.total:${JSON.stringify(logData.total)}|logData.items.length:${JSON.stringify(logData.items.length)}`)
                    //   })
                  })
              })
            } else {
              this.loggerService.setOutputProvider(BrowserConsoleOutputProvider)
            }
          })
      })
  }

  ngOnInit() {
    // first get environment variables
    this.env.getEnv().subscribe(this.envUpdate.bind(this))

    this.updateTitle()

    this.searchGroup = new FormGroup({
      searchVal: new FormControl('', Validators.required)
    })

    // auth
    this.authService.getAuthSession()
    this.loginId = this.authService.idSubject
    this.isAdmin = this.authService.admin

    if (window.innerWidth <= 950) {
      this.menuOpen = false
    }
  }

  isRouteLink(sub) {

    if (typeof sub.uri === 'undefined') {
      return false
    }
    if (sub.uri.startsWith('/') === true) {
      return true
    }
    if (typeof sub.isRouteLink !== 'undefined' && sub.isRouteLink === true) {
      return true
    }
    if (sub.uri.indexOf('http:') === -1 && sub.uri.indexOf('https:') === -1) {
      return true
    }
    return false
  }

  menuUpdate(data: any) {
    this.menus = data;
  }

  envUpdate(env: any) {
    this.menuService.getMenus().subscribe(
      res => {
        this.menuUpdate(res)
      },
      err => {
        this.errorService.setErrorCode("", err)
      }
    )

    this.maincontentService.getContent().subscribe(this.contentUpdate.bind(this))

  }

  contentUpdate(data: any) {
    this.maincontent = data;
    this.setProductLink('home')
  }

  updateTitle() {
    this.router.events.subscribe((event) => {
      if (event instanceof NavigationEnd) {

        this.returnTop()

        let page = event.urlAfterRedirects
          .replace(COMMON_URL, "")
          .split("/")
          .join(" ")
          .trim()

        // dont show search params
        if (page.indexOf('?') > 0) {
          page = page.substring(0, page.indexOf('?'))
        }

        this.titleService.setTitle(TITLE + " " + page)
      }
    })
  }

  onSearchSubmit() {
    //    console.log("@@@ ="+JSON.stringify(value))
    // TODO get validation working
    if (this.search) {
      this.router.navigate(['/search/' + this.search])
    }
  }

  setProductLink(uri) {
    let prod = uri.split('/')
    if (this.maincontent) {
      for (let i = 0; i < this.maincontent.product.length; i++) {
        if (this.maincontent.product[i].name.toLowerCase() === prod[0].toLowerCase()) {
          this.productLink = this.maincontent.product[i].erevenueUrl
          return
        }
      }
      this.productLink = this.maincontent.product[0].erevenueUrl
    } else {
      this.productLink = ''
    }
  }

  onSaveChange(value) {
    console.log("onSaveValue =" + value)
    this.search = value
    // TODO get validation working
    //    this.router.navigate(['/search/'+l])
  }

  returnTop() {
    window.scrollTo(0, 0)
  }

  skipto() {
    let maina = document.getElementById("mainarea")
    let focusable = maina.querySelectorAll('a,button,input') // tab elements
    let firstElement = (focusable[0] as HTMLElement)
    firstElement.focus()
  }

  logout() {
    this.authService.logout()
  }

  // fix for USWDS bug - hidden menu items getting focus
  onResize(event) {
    if (event.target.innerWidth <= 950) {
      this.menuOpen = false
    } else {
      this.menuOpen = true
    }
  }

  // fix for USWDS bug - hidden menu items getting focus
  menuOpened() {
    this.menuOpen = true
  }

  // fix for USWDS bug - hidden menu items getting focus
  menuClosed() {
    this.menuOpen = false
  }

  // TODO take out one day !!!!!!!!!
  fakeadmin() {
    this.authService.fakeadmin()
    this.router.navigate(['/'])
  }

}
