import * as Axe from 'axe-core'

// Put axe-core rules to exclude here because they
// don't work in browserless unit testing
const axeOptions = {
  "rules": {
    "color-contrast": { enabled: false }, // color contrast doesn't work
    "html-has-lang": { enabled: false }, // lang attribute always missing
    "meta-viewport": { enabled: false } // viewport doesn't work
  }
}

export class KarmaHelper {

  static axeOptions() {
    return axeOptions
  }

  static axeViolationLog(res: Axe.AxeResults) {
    for (let i = 0; i < res.violations.length; i++) {
        console.error(" VIOLATION: " + res.violations[i].id
            .toUpperCase() + " " + res.violations[i].description)
    }
  }

}
