//us3213.e2e.ts
import 'jasmine';
import {browser, by} from 'protractor';
import {Pages} from '../helpers/pages';
import {Helpers} from '../helpers/helpers';

var pages = new Pages();
var helpers = new Helpers();

describe('US3213 Remove All Product Specific Content Boxes from the MCCF EDI TAS Portal Home Page', function() {

  beforeAll(function() {
    //
  });

  beforeEach(function() {
    pages.home.get();
    helpers.sizeToStandardDesktop();
  });

  it('TC2004 Validate Product Specific Content Boxes are no longer being displayed on the MCCF EDI TAS Portal Home Page', function() {
    
    expect(browser.isElementPresent(pages.home.eAdminContainer)).toBe(false);
    expect(browser.isElementPresent(pages.home.eInsuranceContainer)).toBe(false);
    expect(browser.isElementPresent(pages.home.ePaymentsContainer)).toBe(false);
    expect(browser.isElementPresent(pages.home.ePharmacyContainer)).toBe(false);
    expect(browser.isElementPresent(pages.home.eBillingContainer)).toBe(false);
    expect(browser.isElementPresent(pages.home.nonMCCFContainer)).toBe(false);
    expect(browser.isElementPresent(pages.home.npiContainer)).toBe(false);

  });

  it('TC2167 Validate Look and Feel of Calendar - Navigate to Future Month', function() {
    
    var monthNames = ["January", "February", "March", "April", "May", "June",
    "July", "August", "September", "October", "November", "December"
    ];
    
    var date = new Date();
    date.setDate(1);
    var month = date.getMonth();
    var year = date.getFullYear();

    for (var i = 0; i < 13; i++) {
      var newMonth = 0;
      var year = date.getFullYear();
      if ( month + i > 11 ) {
        newMonth = (month + i) - 12;
        year = year + 1;
      } else {
        newMonth = month + i;
      };
      var monthName = monthNames[newMonth] + " " + year;

      (function(m) {
        pages.home.calendarCurrentMonth.getText().then( function(value) {
          expect( m ).toEqual(value);
          //console.log(m);
          //console.log(value);
        });
        pages.home.next.click();
      })(monthName);
    };

    it('TC2166 Validate Look and Feel of Calendar - Go Back to Prior Month', function() {
    
    var monthNames = ["January", "February", "March", "April", "May", "June",
    "July", "August", "September", "October", "November", "December"
    ];
    
    var date = new Date();
    date.setDate(1);
    var month = date.getMonth();
    var year = date.getFullYear();

    for (var i = 0; i < 13; i++) {
      var newMonth = 0;
      var year = date.getFullYear();
      if ( month - i < 0 ) {
        newMonth = (month - i) + 12;
        year = year - 1;
      } else {
        newMonth = month - i;
      };
      var monthName = monthNames[newMonth] + " " + year;

      (function(m) {
        pages.home.calendarCurrentMonth.getText().then( function(value) {
          expect( m ).toEqual(value);
          //console.log(m);
          //console.log(value);
        });
        pages.home.previous.click();
      })(monthName);
    };
    
  });
    
  });
  
  



});
