//us3212.compliance.e2e.ts
import 'jasmine';
import {browser, by} from 'protractor';
import {Pages} from '../helpers/pages';
import {Helpers} from '../helpers/helpers';

var AxeBuilder = require('axe-webdriverjs');

var pages = new Pages();
var helpers = new Helpers();

describe('US3212 Enhance Linking to URLs from the MCCF EDI TAS Portal', function() {

  beforeAll(function() {
    //
  });

  beforeEach(function() {
    pages.home.get();
    helpers.sizeToStandardDesktop();
  });

  it('TC2210 Verify the breadcrumb on the eInsurance page has sufficient color contrast', function() {
    pages.menuNav.eInsurance.click();
    expect(pages.eInsurance.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2223 Verify the breadcrumb on the ePharmacy page has sufficient color contrast', function() {
    pages.menuNav.ePharmacy.click();
    expect(pages.ePharmacy.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  xit('TC2224 Verify the breadcrumb on the eBilling page has sufficient color contrast', function() {
    pages.menuNav.eBilling.click();
    expect(pages.eBilling.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2225 Verify the breadcrumb on the ePayments page has sufficient color contrast', function() {
    pages.menuNav.ePayments.click();
    expect(pages.ePayments.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  }); 

  it('TC2226 Verify the breadcrumb on the Non-MCCF page has sufficient color contrast', function() {
    pages.menuNav.nonMCCF.click();
    expect(pages.nonMCCF.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2227 Verify the breadcrumb on the NPI page has sufficient color contrast', function() {
    pages.menuNav.npi.click();
    expect(pages.npi.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  }); 

  xit('TC2228 Verify the breadcrumb on the eAdmin page has sufficient color contrast', function() {
    pages.menuNav.eAdmin.click();
    expect(pages.eAdmin.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('color-contrast').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  xit('TC2237 Verify the breadcrumb on the eAdmin page only uses allowed ARIA attributes', function() {
    pages.menuNav.eAdmin.click();
    expect(pages.eAdmin.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); 
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2238 Verify the breadcrumb on the eInsurance page only uses allowed ARIA attributes', function() {
    pages.menuNav.eInsurance.click();
    expect(pages.eInsurance.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); 
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2239 Verify the breadcrumb on the ePharmacy page only uses allowed ARIA attributes', function() {
    pages.menuNav.ePharmacy.click();
    expect(pages.ePharmacy.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); 
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2240 Verify the breadcrumb on the eBilling page only uses allowed ARIA attributes', function() {
    pages.menuNav.eBilling.click();
    expect(pages.eBilling.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); 
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2242 Verify the breadcrumb on the ePayments page only uses allowed ARIA attributes', function() {
    pages.menuNav.ePayments.click();
    expect(pages.ePayments.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); 
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2243 Verify the breadcrumb on the Non-MCCF page only uses allowed ARIA attributes', function() {
    pages.menuNav.nonMCCF.click();
    expect(pages.nonMCCF.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); 
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2244 Verify the breadcrumb on the NPI page only uses allowed ARIA attributes', function() {
    pages.menuNav.npi.click();
    expect(pages.npi.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('aria-allowed-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); 
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  xit('TC2248 Verify the breadcrumb on the eAdmin page only uses allowed ARIA attributes', function() {
    pages.menuNav.eAdmin.click();
    expect(pages.eAdmin.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('aria-required-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); 
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2249 Verify the breadcrumb on the eInsurance page only uses allowed ARIA attributes', function() {
    pages.menuNav.eInsurance.click();
    expect(pages.eInsurance.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('aria-required-attr').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); 
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  xit('TC2255 Verify the breadcrumb on the eAdmin page uses <li> elements contained in a <ul> or <ol>', function() {
    pages.menuNav.eAdmin.click();
    expect(pages.eAdmin.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('listitem').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); 
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2263 Verify the breadcrumb on the eInsurance page uses <li> elements contained in a <ul> or <ol>', function() {
    pages.menuNav.eInsurance.click();
    expect(pages.eInsurance.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('listitem').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); 
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2264 Verify the breadcrumb on the ePharmacy page uses <li> elements contained in a <ul> or <ol>', function() {
    pages.menuNav.ePharmacy.click();
    expect(pages.ePharmacy.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('listitem').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); 
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2265 Verify the breadcrumb on the eBilling page uses <li> elements contained in a <ul> or <ol>', function() {
    pages.menuNav.eBilling.click();
    expect(pages.eBilling.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('listitem').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); 
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2266 Verify the breadcrumb on the ePayments page uses <li> elements contained in a <ul> or <ol>', function() {
    pages.menuNav.ePayments.click();
    expect(pages.ePayments.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('listitem').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); 
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  })

  it('TC2267 Verify the breadcrumb on the Non-MCCF page uses <li> elements contained in a <ul> or <ol>', function() {
    pages.menuNav.nonMCCF.click();
    expect(pages.nonMCCF.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('listitem').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); 
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC2268 Verify the breadcrumb on the NPI page uses <li> elements contained in a <ul> or <ol>', function() {
    pages.menuNav.npi.click();
    expect(pages.npi.welcome.isDisplayed()).toBe(true);
    AxeBuilder(browser).include(pages.breadcrumbs.css_breadcrumb).withRules('listitem').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0); 
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });



});
