//us2205.compliance.e2e.ts
import 'jasmine';
import {browser, by, element, protractor} from 'protractor';
import {Pages} from '../helpers/pages';
import {Helpers} from '../helpers/helpers';
var AxeBuilder = require('axe-webdriverjs');
var pages = new Pages();
var helpers = new Helpers();

describe('US2205 (Copy of) 508.01.02.01 Web Application Text Equivalents (1194.22A)', function() {

  beforeAll(function() {
    //
  });

  beforeEach(function() {
    pages.home.get();
    helpers.sizeToStandardDesktop();
  });

  // AXE

  it('TC1455 Verify that the "Here\'s how you know" button displays discernable text for Screen Reader interaction.', function() {
    AxeBuilder(browser).include(pages.usaBanner.css_heresHowYouKnowButton).withRules('button-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1456 Verify that the "eInsurance" navigational menu item button displays discernable text for Screen Reader interaction.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_eInsurance).withRules('button-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1457 Verify that the "ePharmacy" navigational menu item button displays discernable text for Screen Reader interaction.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_ePharmacy).withRules('button-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1458 Verify that the "eBilling" navigational menu item button displays discernable text for Screen Reader interaction.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_eBilling).withRules('button-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1459 Verify that the "ePayments" navigational menu item button displays discernable text for Screen Reader interaction.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_ePayments).withRules('button-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1460 Verify that the "Non-MCCF" navigational menu item button displays discernable text for Screen Reader interaction.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_nonMCCF).withRules('button-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1461 Verify that the "NPI" navigational menu item button displays discernable text for Screen Reader interaction.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_npi).withRules('button-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  xit('TC1462 Verify that the "eAdmin" navigational menu item button displays discernable text for Screen Reader interaction.', function() {
    AxeBuilder(browser).include(pages.menuNav.css_eAdmin).withRules('button-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      // expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1464 Verify that the "Search" submit button displays discernable text for Screen Reader interaction.', function() {
    expect( pages.menuNav.searchButton.isDisplayed() ).toBe(true);
    AxeBuilder(browser).include(pages.menuNav.css_searchButton).withRules('button-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  xit('TC1466 Verify that the calendar widget "Prev" button displays discernable text for Screen Reader interaction.', function() {
    AxeBuilder(browser).include(pages.home.css_previous).withRules('button-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  xit('TC1467 Verify that the calendar widget "Next" button displays discernable text for Screen Reader interaction.', function() {
    AxeBuilder(browser).include(pages.home.css_next).withRules('button-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1479 The HTML document\'s "eBusiness Solutions" logo must have alternate text.', function() {
    AxeBuilder(browser).include(pages.topNav.css_logo).withRules('image-alt').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  xit('TC1525 Validate that the "Skip to main content" hyperlink displays discernable text for Screen Reader interaction.', function() {
    element( by.css('body') ).sendKeys(protractor.Key.TAB);
    AxeBuilder(browser).include(pages.home.css_skip).withRules('link-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  // US3642.1
  xit('TC1532 Validate that the "Help" hyperlink in the footer displays discernable text for Screen Reader interaction.', function() {
    AxeBuilder(browser).include(pages.footer.css_help).withRules('link-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  // US3642.1
  xit('TC1533 Validate that the "PII             " @mailto: hyperlink in the footer displays discernable text for Screen Reader interaction.', function() {
    AxeBuilder(browser).include(pages.footer.css_email).withRules('link-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  // US3642.1
  xit('TC1531 Validate that the "Contact Us" hyperlink in the footer displays discernable text for Screen Reader interaction.', function() {
    AxeBuilder(browser).include(pages.footer.css_contactUs).withRules('link-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  // US3642.1
  xit('TC1530 Validate that the "FAQ" hyperlink in the footer displays discernable text for Screen Reader interaction.', function() {
    AxeBuilder(browser).include(pages.footer.css_faq).withRules('link-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1529 Validate that the "Help" hyperlink in the Secondary Navigation area displays discernable text for Screen Reader interaction.', function() {
    AxeBuilder(browser).include(pages.topNav.css_help).withRules('link-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1528 Validate that the "Contact Us" hyperlink in the Secondary Navigation area displays discernable text for Screen Reader interaction.', function() {
    AxeBuilder(browser).include(pages.topNav.css_contactUs).withRules('link-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1527 Validate that the "FAQ" hyperlink in the Secondary Navigation area displays discernable text for Screen Reader interaction.', function() {
    AxeBuilder(browser).include(pages.topNav.css_faq).withRules('link-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

  it('TC1526 Validate that the "eBusiness Solutions" logo text hyperlink displays discernable text for Screen Reader interaction.', function() {
    AxeBuilder(browser).include(pages.topNav.css_eBusinessSolutions).withRules('link-name').analyze(function(results) {
      expect(results.incomplete.length).toEqual(0);
      expect(results.violations.length).toEqual(0);
      expect(results.passes.length).toEqual(1);
    });
  });

});