#! /bin/bash
#
clear

# CONTACT INFO
CONTACT="Lee Benhart: lee.benhart@Halfaker.com or PII"

# NAME OR IP OF REPO FILES

DEVREPOSRC="aws-master.mccf.halfakerlabs.com"

#
# Verify ROOT user is running this
MYID="`/usr/bin/id -u`"
if [ "$MYID" -ne 0 ] ; then echo $0: You must be root to run this 1>&2 ; exit 1 ; fi
#

echo ""

TARGETREPOSRC=$(hostname)

if [ -z "${TARGETREPOSRC}" ] 
then
    echo "$0 ${TARGETREPOSRC} not found, contact ${CONTACT}"
fi

echo "$0 Synchronizing install to VA environment... "
echo "$0 My local address is ${TARGETREPOSRC}"

echo ""
echo "$0 Copy the relevant files to the html location"

PUBDIR="/var/www/html/pub"
REPOBASEDIR="${PUBDIR}/repo"
REPODIR="${REPOBASEDIR}/jenkins"

if [ ! -d "${PUBDIR}" ]
then
    mkdir ${PUBDIR}
    echo "$0 Fix directory owner and permissions ${PUBDIR}"
    chown -R root:root "${PUBDIR}"
    chmod 0755 "${PUBDIR}"
    echo "$0 task completed"
fi

if [ ! -d "${REPODIR}" ]
then
    mkdir ${REPODIR}
    echo "$0 Fix directory owner and permissions ${REPODIR}"
    chown -R root:root "${REPODIR}"
    chmod 0755 "${REPODIR}"
    echo "$0 task completed"
fi

rsync -av --progress . ${REPODIR} --exclude '.git*' --exclude 'README.md' --exclude '*.bak' --exclude '*.sh' --del

if [ -s "${REPODIR}" ]
then
    echo "$0 Fix directory owner and permissions ${REPODIR}"
    chown -R root:root "${REPODIR}"
    chmod 0755 "${REPODIR}"
    find ${REPODIR} -type d -exec chmod 0755 '{}' \;
    find ${REPODIR} -type f -exec chmod 0644 '{}' \;
    echo "$0 task completed"
else
    echo "$0 ${REPODIR} not found, contact ${CONTACT}"
fi

restorecon -R "/var/www/html"
if [ $? -ne 0 ] ; then echo "$0: Please report any errors to ${CONTACT}" ; fi

