#!/bin/bash
#

# Script variables
declare SCRIPT_NAME="${0##*/}"
declare SCRIPT_DIR="$(cd ${0%/*} ; pwd)"
declare ROOT_DIR="$PWD"
declare ROLES_DIR="$(cd ../../roles ; pwd)"

## Script variables
USERNAME="${1}"
PASSWD="${2}"
REPO_FILE="rtcCheckinRequirements.yml"

USERNAME="${USERNAME//@/%40}"
PASSWD="${PASSWD//@/%40}"

###############################################################################
# name: getReposFromBB()
# description: gets repos from bitbucket
# inputs: REPO_FILE
# output: all repos specified in roles directory
###############################################################################
function getReposFromBB() {
  REPOS=$(sed -n -e '/^\s*name/p' ${REPO_FILE} | cut -d':' -f 2 | sed 's/^ *//;s/ *$//')
  for repo in ${REPOS} ; do
    PROJECT_NAME="${repo}"
    echo "--> ${PROJECT_NAME}"
    PROJECT_PATH="${ROLES_DIR}/${PROJECT_NAME}"
    echo "--> ${PROJECT_PATH}"
    # Make sure the required directories don't exist
    if [ -e "${PROJECT_PATH}" ] ; then
      echo -e "Role ${PROJECT_NAME} already exists!"
      cd "${ROLES_DIR}"
      rm -rf "${PROJECT_NAME}"
    fi
      # create get the role
    echo -e "INFO: getting role ${PROJECT_NAME}..."
    echo -e "===================================================="
    cd "${ROLES_DIR}"
    mkdir ${PROJECT_NAME}

    shopt -s extglob
    USERORIGIN="https://${USERNAME}:${PASSWD}@bitbucket.org/halfaker/${PROJECT_NAME}.git"
    git clone ${USERORIGIN} "/tmp/${PROJECT_NAME}"
  #  rsync -av --exclude ".git*" --exclude ".git/" "/tmp/${PROJECT_NAME}" .
    cp -r "/tmp/${PROJECT_NAME}" .
    rm -rf "${PROJECT_NAME}/.git"
    rm -rf "/tmp/${PROJECT_NAME}"
    echo
  done
  echo "--> specified repositories retrieved"
}

###############################################################################
# name: cleanJenkinsSync()
# description: cleanup directory to remove everything except jobs directory
# inputs: ${ROLES_DIR}/mccf_jenkins_sync_config must exist
# output: a clean directory
###############################################################################
function cleanJenkinsSync() {
  if [[ -d "${ROLES_DIR}/mccf_jenkins_sync_config" ]]
  then
    echo "--> Cleaning ${ROLES_DIR}/mccf_jenkins_sync_config"
    cd "${ROLES_DIR}/mccf_jenkins_sync_config"
    ls -1 | grep -v -E 'jobs' | xargs rm -R 
    if [[ -d "jobs" ]]
    then
      echo "--> YEAH, we have jobs to sync"
    else
      echo "--> oops, epic fail"
    fi
  fi
}

echo 
echo "SCRIPT_NAME: ${SCRIPT_NAME}"
echo "SCRIPT_DIR: ${SCRIPT_DIR}"
echo "ROOT_DIR: ${ROOT_DIR}"
echo "ROLES_DIR: ${ROLES_DIR}"
echo

# Detect proper usage
if [ "$#" -ne "2" ] ; then
  echo -e "ERROR: Usage: $0 <username> <passwd>"
  exit 1
fi

if [[ ! -e ${REPO_FILE} ]]
then
  echo "${REPO_FILE} not found, exiting"
  exit 1
fi
echo "processing: ${REPO_FILE}"

getReposFromBB
cleanJenkinsSync
