#!/usr/bin/env node
// this create the same sha1 hash used by sinopia
// created to assist with verification of sinopia htpasswd.

var crypto = require("crypto");
try {
  // optional, won't be available on windows
  var crypt3 = require('crypt3')
} catch(err) {
}
const path = require('path');
var args = process.argv.slice(2)

if(args.length == 0)
{
    console.log("Arguments missing. Script needs at least one argument (Basic Auth) to run successfully: node " + path.basename(__filename) + " arg1. exiting.....");
    process.exit(1);
}

// console.log(args[0])

if (crypt3) {
  console.log("%s %s: %s" , __filename,new Date().toISOString(), "create cipher, of input string, uding crypt3")
  cipher = crypt3(args[0])
} else {
  console.log("%s %s: %s" , __filename,new Date().toISOString(), "create 'sha1' cipher, of input string, in base64")
  cipher = '{SHA}' + crypto.createHash('sha1').update(args[0], 'binary').digest('base64')
}
console.log("%s %s: %s" , __filename,new Date().toISOString(), cipher)
