// increment jobs listed in jobMap
// must first obtain jobMap by running getJobMap
// only incremenent jobs where the build number matters.

//def jobMap = ["INSTALL_TASKS/configureFortifyPipeline":4,"INSTALL_TASKS/configureWebserver":19,"INSTALL_TASKS/installFortifyPipeline":2,"INSTALL_TASKS/installGlobalNPM_Packages":31,"INSTALL_TASKS/installSinopiaPipeline":18,"MaintenanceTasks/jenkins_test_access":10,"MaintenanceTasks/MCCF_JENKINS_REPO_monitor":120,"MaintenanceTasks/MCCF_MISC_REPO_monitor":140,"MaintenanceTasks/MCCF_SINOPIA_REPO_monitor":878,"MaintenanceTasks/MCCF_YUM_REPO_monitor":1402,"MaintenanceTasks/OWASP_Dependency-Check_NVD_Update":6,"MaintenanceTasks/rtc_pipeline_test":155,"MaintenanceTasks/rtc_test_access":30,"MCCF_TAS/deploy_MCCF_TAS_Core":150,"MCCF_TAS/deploy_RTC_MCCF_TAS_Core":67,"MCCF_TAS/MCCF_TAS_Core":309,"MCCF_TAS/MCCF_TAS_Scanning":98,"MCCF_TAS/RTC_MCCF_TAS_Core":160,"MCCF_TAS/RTC_MCCF_TAS_FORTIFY_SCAN":73]
def jobMap = ["MCCF_TAS/MCCF_TAS_Core":334,"MCCF_TAS/RTC_MCCF_TAS_Core":176]

jobMap.each { entry -> 
  println "--------------------------"
  println "test for JOB:  $entry.key "
  def setJob = Jenkins.instance.getItemByFullName(entry.key)
  if(setJob){
    if(setJob.getLastBuild()){
      def lastBuild = setJob.getLastBuild().getNumber()
      if(lastBuild < entry.value){
        println "--> set next build number for JOB:  $setJob.fullName"
        println "-->               from last build:  $lastBuild " + setJob.getLastBuild().displayName
        println "-->                 to next build:  $entry.value" 
        setJob.nextBuildNumber = entry.value
        setJob.save()
      }
      else{
        println "lastBuild is higher than new setting"
      }
    }
    else{
      println " -> JOB has never executed"
    }
    def nextID = setJob.getNextBuildNumber()
    println "$setJob.fullName next build is now:  $nextID, expected: " + entry.value
    if(nextID != entry.value){
      println " -> Next build number not incremented, something bad happened"
    }
  }
  else{
    println " -> JOB does not exist"
  }
}
// returns blank
''
jobMap