// Return a list of jobs, the last build number, and the last build status
//returned jobMap can be used with other scripts
def jobMap = [:]
jobs = Jenkins.instance.getAllItems()
jobs.each { j ->
  if (j instanceof com.cloudbees.hudson.plugins.folder.Folder) { return }
  println '---'
  println 'JOB: ' + j.fullName
  numbuilds = j.builds.size()
  if (numbuilds == 0) {
    println '  -> no build'
    return
  }
  lastbuild = j.getLastBuild()
    println '  -> lastbuild: ' + lastbuild.displayName + ' = ' + lastbuild.result + ', time: ' + lastbuild.timestampString2

  nextBuild = j.getNextBuildNumber()
   println '  -> nextBuild: ' + nextBuild
  if(j.fullName){
    jobMap.put("$j.fullName" , nextBuild)
  }
}

// returns blank
''
jobMap