def from = "ci"
def to = "cit"

def www_root = "/var/www/html"
def createLink = "ln -sfn"
def fromLinkName = "latest_${from}"
def toLinkName = "latest_${to}"

def sOut = new StringBuilder(), sErr = new StringBuilder()
def queryPath = "ls ${www_root}/${fromLinkName}".execute()

def fromExists = queryPath.consumeProcessOutput(sOut,sErr)
queryPath.waitForOrKill(1000)

println "out> $sOut err> $sErr"

if(!sErr){
  println "follow symlink"
  def getLink = "readlink -f $sOut"
  
  def proc = getLink.execute()

  proc.waitForOrKill(1000)

  def exit = proc.exitValue()
  def link = proc.in.text
  def err = proc.err.text

  println "return code: ${exit}"
  println "err code: ${err}"

  if(exit){
    println "exit is ${exit}"
  }
  else{
    if(link?.trim()){
      println "Found ${fromLinkName}: ${link}"
      println "create link for ${toLinkName}: ${link}"
    }
    else{
      println "unable to find ${fromLinkName}"
    }
  }
}