mccfrolesmwebagent
=========

The installation program for the SiteMinder agent installs the agent on one computer at a time using the UNIX or Linux operating environments. This installation program can be run in wizard or console modes. The wizard and console-based installation program also creates a .properties file for subsequent installations and configurations using the unattended or silent method with the same settings.
For example, suppose the Agents in your environment use the same web server version, installation directory, Agent Configuration Object and Policy Servers. Use the installation wizard or console-based installation program for your first installation. Afterwards, you could create your own script to run the installation program with the .properties file the wizard or console-based installation program created.

Requirements
------------
VA ONLY
Any pre-requisites that may not be covered by Ansible itself or the role should be mentioned here. 

Role Variables
```
# current siteminder webagent version
siteminder_version: "12.51"
# current siteminder webagent release version
siteminder_release: "cr08"
# name of download file
siteminder_download_file: "smwa-{{ siteminder_version }}-{{ siteminder_release }}-linux-x86-x64.zip"

# name of installer
siteminder_installer: "ca-wa-{{ siteminder_version }}-{{ siteminder_release }}-linux-x86-x64.bin"
# properties file for silent install
siteminder_properties: "layout.properties"
# install directory
web_agent_home: /opt/siteminder/webagent
web_agent_installation_config: "{{ web_agent_home }}/install_config_info"

```
------------
# Install Instructions

Follow these steps:
NOTE: run as sudo.

1. Obtain the zip file for the installer and the properties file
2. Extract SiteMinder agent installation executable file to a temporary directory on your web server.
3. Make the installer executable
    ``` chmod +x the installer file ```
4. For console-based installations, open a command-line window and run the executable as shown in the following example:
    ``` executable_file_name.exe -i console ```
5. Accept license agreement
6. Accept default installation location
7. Configure Apache Web Agent
  + cd to web_agent_home
  + source the environment variables
  ```
  cd {{ web_agent_home }}
  . ./ca_wa_env.sh
  ```
  + cd to the config directory
  + launch configuration wizard
  ```
  cd {{ web_agent_installation_config }}
  . ./ca-wa-config.bin
  ```
# How to Configure Agents on UNIX/Linux
See included PDF for settings
    + Type 1 to register trusted hosted
    + Enter Admin User Name
    + Do not enable shared secret rollover (default is n)
    + Enter the password for the admin username
    + Enter the trusted host name
    + Enter the trusted host ip configuration object
    + Type the policy server ip address
    + FIPS Mode Setting is 3-FIPS Only Mode
    + Accept default file name and location of host configuration
    + Select Webserver, 1- Apache Web Server
    + specify the path to apache instance (/usr/share/httpd)
    + select the apache version (3 - Apache version 2.2.x)
    + select apache type (6 - HTTP Apache)
    + Type 1 to confirm Apache server to configure
    + Enter the name of the Agent Configuration Object
    + Select Basic over SSL Authentication as SSL Authentication type
    + For Self Registration: Select 2- No
    + Web Server Confirmation Summary, select 1 to continue

#	Post Configuration Edits
After the configuration wizard runs, edit SmHost.conf and WebAgent.conf to apply custom edits.

1. Edit SmHost.conf to add bootstrap policy servers.
    + Change directory to /home/apache/CA/webagent/config
    + Add the additional policy servers to the list.
  ```
  # Add additional bootstrap policy servers here for fault tolerance.
  policyserver="xxx.xxx.xx.x,44441,44442,44443"
  policyserver=" xxx.xxx.xx.x,44441,44442,44443"
  ```
2. Edit the following on /home/apache/httpd/conf/WebAgent.conf to enable the agent:
``` EnableWebAgent=”YES” ```

3. For an embedded Apache web server (included by default) on a RedHat Linux system, modify certain configuration files to accommodate the product first.
  ```
  Follow these steps:.
    Open the following file with a text editor:
  /etc/sysconfig/httpd
    Add the following line to the end of the file:
  PATH=$PATH:web_agent_home/bin
  ```
4. Source ca_wa_env.sh  script in the following file (instead of starting it manually each time): /etc/init.d/htppd
5. If you run your Apache server using the apachectl script (such as when running an Apache web server on POSIX). Adding a line to the apachectl script sets the environment variables for the agent.
  ```
  Follow these steps:
    Locate a line resembling the following example:
  # Source /etc/sysconfig/httpd for $HTTPD setting, etc
    Add the following line after the line in the previous example:
  sh /web_agent_home/ca_wa_env.sh
  
  ```
  NOTE: web_agent_home Indicates the directory where the CA SiteMinder® Agent is installed.
  Default (UNIX/Linux installations): /opt/ca/webagent
6.	Restart Apache and check the logs for connection or errors.
  ```
  To restart Apache, follow the following steps (don’t use “restart” option):
      Stop Apache.
      Check to make sure LLWAP process has stopped (it may take a bit of time), if not kill it.
      Start Apache
  ```

## With RHEL 7.x you’d have to do the sourcing of the ca_wa_env.s h differently 
See (https://www.ca.com/us/services-support/ca-support/ca-support-online/knowledge-base-articles.tec1340867.html), one way of doing that is:

1.	[root@yourserver sysconfig]# vi /AnyProtectedDir/set-apache-env.sh
Add the following content to this script:

  ```#!/bin/sh
    PATH=$PATH:/SomePathTo/webagent/bin
    . /SomePathTo/webagent/ca_wa_env.sh
  ```
2. 	Save and quit
3. 	[root@yourserver sysconfig]# chmod a+x /AnyProtectedDir/set-apache-env.sh
4. 	[root@yourserver etc]# vi /usr/lib/systemd/system/httpd.service
5. 	Change these lines:
  ```
    ExecStart=/usr/sbin/httpd $OPTIONS -DFOREGROUND
    ExecReload=/usr/sbin/httpd $OPTIONS -k graceful
  ```
6. 	To these lines:
  ```
  #ExecStart=/usr/sbin/httpd $OPTIONS -DFOREGROUND
  ExecStart=/bin/bash -a -c 'source /AnyProtectedDir/set-apache-env.sh && exec /usr/sbin/httpd $OPTIONS -DFOREGROUND'

  # ExecReload=/usr/sbin/httpd $OPTIONS -k graceful
  ExecReload=/bin/bash -a -c 'source /AnyProtectedDir/set-apache-env.sh && exec /usr/sbin/httpd $OPTIONS -k graceful'
  ```
7.	[root@yourserver etc]# systemctl daemon-reload
8.	[root@yourserver etc]# service httpd stop
9.	Check to make sure LLWAP process has stopped.
10.	[root@ yourserver etc]# service httpd start



Example Playbook
----------------

Including an example of how to use your role (for instance, with variables passed in as parameters) is always nice for users too:

    - hosts: servers
      roles:
         - { role: username.rolename, x: 42 }

License
-------

BSD

Author Information
------------------

An optional section for the role authors to include contact information, or a website (HTML is not allowed).
