# Ansible Role: Node.js

Installs Node.js on RHEL/CentOS.
## To install this role, one of several options can be employed
First, create a requirements.yml file for your project, specifying the source repo in git
then,

1) using ansible-galaxy command, install the role to the local roles path specified in the local ansible.cfg
   
   `ansible-galaxy install -f -r test-requirements.yml`

   or

   2) create a playbook to install the roles, along with any other setup tasks
   
   `ansible-playbook test.yml -i "../environments/${ENV}" --extra-vars "var_hosts=${HOSTS}"`

   or

   3) pull the source directly from git to the local roles_path (this is the least favorable option)
   
Once installed, the role can then be used in the playbook like any lcally defined role.

## Role Variables

Available variables are listed below, along with default values (see `defaults/main.yml`):

    nodejs_mccf_version: "8.*"

The Node.js version to install.

    nodejs_install_npm_user: "{{ ansible_ssh_user }}"

The user for whom the npm packages will be installed can be set here, this defaults to ansible_user

    npm_config_prefix: "~/.npm-global"

The global installation directory. This should be writeable by the nodejs_install_npm_user.

    npm_config_unsafe_perm: "false"

Set to true to suppress the UID/GID switching when running package scripts. If set explicitly to false, then installing as a non-root user will fail.

    nodejs_npm_global_packages: []

For installation of global NPM packages (if desired): Add a list of npm packages with a `name` and (optional) `version` to be installed globally. For example:

    nodejs_npm_global_packages:
      # Install a specific version of a package.
      - name: jslint
        version: 0.9.3
      # Install the latest stable release of a package.
      - name: node-sass

## Dependencies

None.

## Example Playbook

    - hosts: webserver
      vars_files:
        - vars/main.yml
      roles:
        - mccfrolenodejs
      tasks:
        - name: check node version
          shell: node --version
          register: node_version

        - name: check npm
          shell: npm --version
          register: npm_version
        
        - debug:
           var: "npm_version.stdout_lines" 

        - debug:
            var: node_version.stdout_lines

*Inside `vars/main.yml`*:

    nodejs_npm_global_packages:
      - name: jslint
      - name: node-sass

## License

## Author Information
