#!/bin/bash
#set -x

#Don't waste any time -- if you're not root, exit now
if [ "${UID}" != "0" ]; then
        echo "$0 Error: You must run this script as root" >&2
        exit 1
fi

TIMESTAMP=`date +%Y%m%d%H%M%S`
VAULTPASS_PATH="~/.vault_pass"
SCRIPTNAME="${0##*/}"
ROOT_DIR="$(cd ..; pwd)"
JENKINS_ROOT="${ROOT_DIR}/roles/mccf_jenkins/plugins"
LOGDIR="${ROOT_DIR}/logs"
LOGFILE="${LOGDIR}/populateNexusRepo-Jenkins-${TIMESTAMP}.log"
ERRLOG="${LOGDIR}/populateNexusRepo-Jenkins-${TIMESTAMP}-error.log"
NEXUS_BASE_URL="http://localhost:8081/repository"
NEXUS_JENKINS_URL="${NEXUS_BASE_URL}/mccf-jenkins-repo"

#LOGTXT writes to logfile
LOGTXT() {
	echo "$*" >> $LOGFILE
} 

#LOGERR writes to error logfile
LOGERR() {
	echo "$*" >> $ERRLOG
} 

#DEBUG sends the arguments passed to the terminal with an EOL at the end
DEBUG() {
   if [ -t 1 ] ; then echo -e "$*" ; fi
}

#rtnCode check
RTNCODE() {
	if [[ $rtnCode -eq 0 ]]; then
        LOGTXT "Successful: curl upload completed successfully for $REPO_FILEPATH"
		LOGTXT " "
	else
		LOGERR "Error: curl upload for $REPO_FILEPATH returned ${rtnCode}"
		LOGERR " "
		exit $rtnCode
	fi
}

#ReadArgs reads the command line arguments passed to it
#and populates shell variables accordingly
readArgs() {
  LOGTXT "Entered readArg"
  while [[ $# -gt 0 ]] ; do
    key="$1"
    case $key in
      -c | --nocolor )
           UseColor=No
           CLEAR=""
           COL60=""
           NORMAL=""
           WHITE=""
           GREEN=""
           RED=""
           YELLOW=""
           BLUE=""
           shift # past argument
           LOGTXT "Processing without color"
           ;;
      -l | --logfile )
           if [[ $# -ge 2 ]] ; then
             LOGFILE="$2"
           else
             DEBUG "$1 argument requires another argument after it"
             LOGTXT "Error in $1 argument (no next argument provided)"
             exit 9
           fi
           LOGTXT "Using LogFile $LOGFILE instead"
           # DEBUG  "Log output redirected to $LOGFILE"
           shift # past argument
           shift # past logfile entry
          ;;
      -u | --user )
           if [[ $# -ge 2 ]] ; then
             USERNAME="$2"
           else
             DEBUG "argument $1 requires another argument after it"
             LOGTXT "Error in $1 argument (no next argument provided)"
             exit 9
           fi
           LOGTXT "USERNAME: $USERNAME "
           # DEBUG  "USERNAME: $USERNAME "
           shift # past argument
           shift # past fqdn entry
           ;;
      -p | --pass )
           if [[ $# -ge 2 ]] ; then
             PASSWD="$2"
           else
             DEBUG "argument $1 requires another argument after it"
             LOGTXT "Error in $1 argument (no next argument provided)"
             exit 9
           fi
           LOGTXT "Using supplied password "
           # DEBUG  "Using supplied password $PASSWD "
           shift # past argument
           shift # past fqdn entry
           ;;
      -s | --skiproles )
           skiproles="true"
           LOGTXT "skiproles: $skiproles, not collecting roles from mccf BB repos"
           DEBUG "skiproles: $skiproles, not collecting roles from mccf BB repos"
           shift # past argument
           ;;
      -e | --env )
           if [[ $# -ge 2 ]] ; then
             ENV="$2"
           else
             DEBUG "argument $1 requires another argument after it"
             LOGTXT "Error in $1 argument (no next argument provided)"
             exit 9
           fi
           LOGTXT "Environment: $ENV"
           # DEBUG  "Environment $ENV"
           shift # past argument
           shift # past fqdn entry
           ;;
      * )  DEBUG "$1 is not a valid argument"
           LOGTXT "$1 is not a valid argument"
           exit 9
           ;;
    esac
  done
  LOGTXT "Exited ReadArgs"
}

#Create file listing of ${REPO_ROOT} and read through file and upload to Nexus
function populateFiles() {
  find $JENKINS_ROOT -name '*' -type f > /tmp/tmpfile
  while IFS=/ read LINE; do
    REPO_FILEPATH="$(echo $LINE | cut -d/ -f8-)"
    REPO_FILE=$(basename $LINE)
    REPO_PATH=${REPO_FILEPATH%/*}
    cd $JENKINS_ROOT
    curl -v --user $USERNAME:$PASSWD --upload-file $REPO_FILE $NEXUS_JENKINS_URL/$REPO_FILEPATH
    #echo "curl -v --user $USERNAME --upload-file $REPO_FILE $NEXUS_JENKINS_URL/$REPO_FILEPATH"
    rtnCode=$?
    RTNCODE
  done < /tmp/tmpfile
  rm -rf /tmp/tmpfile
}

#Check if log directory exists and if not, create it
if [[ ! -d ${LOGDIR} ]]; then
	${MKDIRCMD} ${LOGDIR}	
fi

readArgs $*
populateFiles
LOGTXT "Completed $0 at `date`"
