#!/bin/bash
set +x

#Don't waste any time -- if you're not root, exit now
if [ "${UID}" != "0" ]; then
        echo "$0 Error: You must run this script as root" >&2
        exit 1
fi

TIMESTAMP=`date +%Y%m%d%H%M%S`
USER="admin"
PASSWORD="Password123!"
SCRIPTBASE="$(cd "$( dirname "$scriptname" )";  pwd)"
ROOT_DIR="$(cd ../..;  pwd)"
MCCF_STORAGE_ROOT="/var/www/html/pub/repo/maven/maven2"
LOGDIR="${ROOT_DIR}/logs"
LOGFILE="${LOGDIR}/importMavenCentralFiles-${TIMESTAMP}.log"
ERRLOG="${LOGDIR}/importMavenCentralFiles-${TIMESTAMP}-error.log"
NEXUS_BASE_URL="http://localhost:8081/repository/maven-central"

#LOGTXT writes to logfile
LOGTXT() {
	echo "$*" >> $LOGFILE
} 

#LOGERR writes to error logfile
LOGERR() {
	echo "$*" >> $ERRLOG
} 

#DEBUG sends the arguments passed to the terminal with an EOL at the end
DEBUG() {
   if [ -t 1 ] ; then echo -e "$*" ; fi
}

#rtnCode check
RTNCODE() {
	if [[ $rtnCode -eq 0 ]]; then
        LOGTXT "Successful: curl upload completed successfully for $REPO_FILEPATH"
		LOGTXT " "
	else
		LOGERR "Error: curl upload for $REPO_FILEPATH returned ${rtnCode}"
		LOGERR " "
		exit $rtnCode
	fi
}

#Check if log directory exists and if not, create it
if [[ ! -d ${LOGDIR} ]]; then
	${MKDIRCMD} ${LOGDIR}	
fi

#Create file listing of /var/www/html/pub/repo/maven/maven2, read through file and upload to Nexus
find $MCCF_STORAGE_ROOT -name '*' -type f > /tmp/tmpfile
while IFS=/ read LINE; do
  REPO_FILEPATH="$(echo $LINE | cut -d/ -f9-)"
  REPO_FILE=$(basename $LINE)
  REPO_PATH=${REPO_FILEPATH%/*}
  cd $MCCF_STORAGE_ROOT/$REPO_PATH
  echo "CURL = curl -v --user $USER:$PASSWORD --upload-file $REPO_FILE $NEXUS_BASE_URL/$REPO_FILEPATH"
  #curl -v --user $USER:$PASSWORD --upload-file $REPO_FILE $NEXUS_BASE_URL/$REPO_FILEPATH
  rtnCode=$?
  RTNCODE
done < /tmp/tmpfile
LOGTXT "Completed $0 at `date`"

