import groovy.json.JsonSlurper
import org.sonatype.nexus.security.user.User
import org.sonatype.nexus.security.user.UserStatus
import org.sonatype.nexus.security.user.UserNotFoundException

parsed_args = new JsonSlurper().parseText(args)

try {
    user = security.securitySystem.getUser(parsed_args.username)
	// disable user
    user.setStatus(UserStatus.disabled)
    security.securitySystem.updateUser(user)
	log.info ("User Added to Repository ${user.dump()}")
} catch (UserNotFoundException e) {
	log.info ("ERROR: User NOT added to Repository ${user.dump()}")
}

