# Ansible Playbook for Nexus

An ansible playbook to build Nexus Repository server.

## Variables
- nexus_version: 3.5.2-01
- nexus_major_version: 3

## Dependencies
Role has a dependency to mccfgroovy and mccfrolejava. This role will install both Groovy and Java if they are not installed.

## Post Install Activities
##### Recipe types used by Nexus are as follows:
* raw-hosted - MCCF custom hosted repos - use script = "create_raw_hosted_proxy.yml"
* maven2-proxy
* npm-proxy
* npm-hosted 
* maven-hosted
* docker-hosted
* docker-proxy
* yum-proxy
* yum-hosted - (THIS ISN'T AVAILABLE YET!!!  EXPECTED IN v3.8)

##### To create a new repo, add the following under mccf_repo_list:
    mccf-<repo name>-repo
      blobstore: "blob-<repo name>"
      recipe: <select recipe type from above list>
      remote_url: <ONLY USED FOR PROXY - enter proxy url>

##### To add a new user, add the following under nexus_local_users:
    username: <username>
    first_name: <firstname> 
    last_name: <lastname>
    email: <email address>
    password: <default password>
    roles:
      - developer

##### To disable users, add the following under disabled_nexus_local_users:
    - username: <username>


