import jenkins.*
import jenkins.model.*
import hudson.*
import hudson.model.*

disableChildren(Hudson.instance.items)

def disableChildren(items) {
  for (item in items) {
    println ("\n" + item.name)
    if (item.class.canonicalName == 'com.cloudbees.hudson.plugins.folder.Folder') {
        println (" --- " + item.name + " is a folder, look for children")
        disableChildren(((com.cloudbees.hudson.plugins.folder.Folder) item).getItems())
    } else if (item.class.canonicalName != 'org.jenkinsci.plugins.workflow.job.WorkflowJob') {
        println (" --- " + item.name + " is not WorkflowJob, safe to disable " + item.class)
        item.disabled=true
        item.save()
        println (" --- " + item.name + " -- disabled: " + item.disabled.toString())
    } else {
    println ( item.name + " -- " + item.class + " -- cannot be disabled" )
    }
  }
}