### Ansible Role for Groovy

## To install this role, one of several options can be employed
First, create a requirements.yml file for your project, specifying the source repo in git
then,

1) using ansible-galaxy command, install the role to the local roles path specified in the local ansible.cfg
   
   `ansible-galaxy install -r test-requirements.yml`

   or

   2) create a playbook to install the roles, along with any other setup tasks
   
   `ansible-playbook test.yml -i "../environments/${ENV}" --extra-vars "var_hosts=${HOSTS}"`

   or

   3) pull the source directly from git to the local roles_path (this is the least favorable option)

## Variables
`groovy_version: "2.4.10"`

`groovy_base: /usr/local/groovy`

`groovy_home: "{{ groovy_base }}/latest"`

`groovy_home_script_name: groovy.sh`

`groovy_directory: "{{ groovy_base }}/groovy-{{ groovy_version }}"`

`groovy_download: "{{ groovy_pkg_url }}/apache-groovy-binary-{{ groovy_version }}.zip"`

`groovy_owner: "{{ ansible_user }}"`

`groovy_group: "{{ groovy_owner }}"`

## Dependencies
Role has a dependency to mccfrolejava. mccfrolejava will install Java if it is not installed.

## Post install activities
Role adds script to /etc/profile.d to add the groovy bin folder to PATH.