# README.md

This repository is intended to house all the tools used for maintaining infrastructure as source.

 [Jenkins Install](#ansible-installation-instructions-for-jenkins)

 [Sinopia Install](#ansible-installation-instructions-for-sinopia)

Please see confluence pages for tips. [Ansible Notes](https://halfaker.atlassian.net/wiki/display/VM/Ansible+Notes)

### Environments defined
Each environment has its own inventory, groups_vars for variables and vault protected items.

The ansible environments identified for DEVOPS include the following:

##### HALFAKER environments
*   .\environments\local
*   .\environments\AWS_DEV

##### VA DEV and CI environments

*   .\environments\EDE_DEV
*   .\environments\EDE_CI

##### VA upper level environments

*   .\environments\EDE_CIT
*   .\environments\EDE_SQA
*   .\environments\EDE_UAT


## Ansible Installation Instructions for Jenkins

An Ansible playbook has been created for installation of Jenkins. The source of the playbook is https://bitbucket.org/halfaker/mccf_devops.
To install the Jenkins CI service, execute the following

1. Get source from Bitbucket
   * The following roles are required for the jenkins install, mccfrolejava, mccfrolejenkins
2. The passwords and other secure information are encrypted using ansible vault, the password is required to successfully use protected files.
   * To store the password, create a password file with the password (ie .vault_pass), change the permissions on this file so it cannot be viewed by anyone but you, DO NOT CHECK IN
3. CD to playbooks directory
4. Execute one of the the following commands to execute a local install (The /playbooks/ansible.cfg defines the default inventory to be `inventory = ../environments/local`)

```
#!yml

    ansible-playbook configure-ci-server.yml -i ../environments/<env> --extra-vars var_hosts=ci-server --vault-password-file <path to the password file>
    ansible-playbook configure-ci-server.yml -i ../environments/<env> --extra-vars var_hosts=ci-server --ask-vault-pass, enter the password when prompted
```

For convenience, there are shell scripts to facilitate local installation, mainly used during the course of testing the playbook.
* <basefolder>\mccf_devops\playbooks\uninstallJenkins.sh - uninstall all components installed with Jenkins
* <basefolder>\mccf_devops\playbooks\installJenkins.sh - syntax check and execute playbook 'configure-ci-server.yml'

***NOTE: do not checkin the password file used to create the vault.***

The playbook will install the following roles

* mccfrolejava
* mccfrolejenkins

The playbook will use the following modules

* ansible-xml

## Update Jenkins users
To update users only, update the jenkins_default_users in environments/<env>/group_vars/ci-server/ci-server for the appropriate environment.
   * ansible-playbook configure-ci-server.yml -i ../environments/<env> --extra-vars var_hosts=ci-server --tags updateUsers


## Ansible Installation Instructions for Sinopia
1. Create a Jenkins pipeline job

2. Select `This project is parameterized`

3. Select `Add Parameter`

    1. Select String Parameter
    2. Name=ENV
    3. Default Value= AWS_DEV in AWS, EDE_DEV in EDE
        i. If this is to be installed in any other environment, use the appropriate name of the environment
    4. Description=The variable used to determine the inventory selector for ansible playbook

4. Pipeline Definition: Pipeline script from SCM
    1. SCM=Git
    2. Repository URL=https://bitbucket.org/halfaker/mccf_devops.git
    3. Credential=jenkins_build
    4. Additional Behavious=Select `Wipe out repository and force clone` from drop down
    5. Script Path=sinopia.jenkinsfile

The playbook will install the following roles

* mccfrolenodejs
* mccfrolesinopia

For convenience, there are shell scripts to facilitate local installation, mainly used during the course of testing the playbook.
* <basefolder>\mccf_devops\playbooks\uninstallSinopia.sh - uninstall all components installed with Sinopia
* <basefolder>\mccf_devops\playbooks\installSinopia.sh - syntax check and execute playbook 'install-sinopia.yml'
