#!/bin/bash
# David Holton - Halfaker 2017/12/20
# David.Holton@Halfaker.com
#
# This script is to assist with creating and mounting /var/log and/or /var/log/audit
# on a running system.  It moves the contents of /var/log onto the newly mounted
# filesystem(s).

MyCall=$1
ManageAuditD(){
	STAT=$1
	case ${STAT} in
		OFF) service auditd stop
		;;
		ON) service auditd start
		;;
	esac
}
ManageServices() {
	STATUS=$1
	case ${STATUS} in
	        OFF) # stop services that normally have on open file(s) on /var/log
		     systemctl stop tuned
		     systemctl stop firewalld
		     ManageAuditD OFF
		     systemctl stop rsyslog
		;;
	        ON) # start services that normally have on open file(s) on /var/log
		     systemctl start tuned
		     systemctl start firewalld
		     ManageAuditD ON
		     systemctl start rsyslog
		;;
	esac
}
PrepVarLog() {
	# make a tmp directory with plenty of room
	mkdir /var/log2

	# sync over the file from var/log to our tmp dir
	rsync -havi --include '*/'  /var/log/ /var/log2
}
MountVarLog() {
	ManageServices OFF
	PrepVarLog

	# Ansible should have already craeted the LV, FS, and put
	#     an entry in fstab for us.
	# mount the new varloglv onto /var/log
	mount /var/log

	# sync from the tmp directory to the newly mounted /var/log
	rsync -havi --include '*/'  /var/log2/ /var/log/

	ManageServices ON
}
MountVarLogAudit() {
        # stop auditd that normally has audit.log open on /var/log/audit
	ManageAuditD OFF
	PrepVarLog

	# create the audit directory on the now mounted /var/log
	#     It may already be there
	mkdir /var/log/audit

	# Ansible should have already craeted the LV, FS, and put
	#     an entry in fstab for us.
	mount /var/log/audit

	# sync from the tmp directory to the newly mounted /var/log
	rsync -havi --include '*/'  /var/log2/audit/ /var/log/audit/

        # start auditd
	ManageAuditD ON
}
${MyCall}
