import {
  fakeAsync,
  async,
  tick,
  ComponentFixture,
  TestBed
} from '@angular/core/testing'
import * as Axe from 'axe-core'
import { HttpModule } from "@angular/http"
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../karma/karma-helper'
import { RouterTestingModule } from '@angular/router/testing';

import { EpharmacyHomeComponent } from './epharmacy-home.component';

import { ActiveState } from '../../core/activestate/activestate.service'

describe('EpharmacyHomeComponent', () => {
  let component: EpharmacyHomeComponent
  let fixture: ComponentFixture<EpharmacyHomeComponent>

  beforeEach(async(() => {

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        HttpModule,
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
        EpharmacyHomeComponent
      ],
      providers: [ActiveState]
    }).compileComponents()
      .then(() => {
        fixture = TestBed.createComponent(EpharmacyHomeComponent)
      })

  }))

  beforeEach(() => {
    component = fixture.componentInstance
    component.ngOnInit()
    fixture.detectChanges()
  })

  afterEach(function () {
    TestBed.resetTestingModule();
  });

  it('should have no accessibility issues', ((done) => {
    // console.error(" @@@@@@@@@@@@@ html="+document.body.innerHTML)

    fixture.whenStable().then(() => {
      Axe.run(document, KarmaHelper.axeOptions()).then((result) => {
        KarmaHelper.axeViolationLog(result)
        expect(result.violations.length).toEqual(0)
        done()
      }).catch((error) => {
        console.error("AXE-CORE ERROR:" + error)
      })
    })
  }))
})
